/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectBytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectByteProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableObjectByteMap;
import com.gs.collections.api.map.primitive.MutableObjectByteMap;
import com.gs.collections.api.map.primitive.ObjectByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.factory.primitive.ObjectByteMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedObjectByteMap;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableObjectByteMap<K>
implements MutableObjectByteMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectByteMap<K> map;

    UnmodifiableObjectByteMap(MutableObjectByteMap<K> map) {
        this.map = map;
    }

    private boolean isAbsent(byte result, K key) {
        return result == 0 && !this.containsKey(key);
    }

    private byte getIfAbsentThrow(K key) {
        byte result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, byte value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectByteMap<? extends K> map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(K key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public byte removeKeyIfAbsent(K key, byte value) {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public byte getIfAbsentPut(K key, byte value) {
        return this.getIfAbsentThrow(key);
    }

    public byte getIfAbsentPut(K key, ByteFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public byte getIfAbsentPutWithKey(K key, ByteFunction<? super K> function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> byte getIfAbsentPutWith(K key, ByteFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public byte updateValue(K key, byte initialValueIfAbsent, ByteToByteFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public byte get(Object key) {
        return this.map.get(key);
    }

    public byte getOrThrow(Object key) {
        return this.map.getOrThrow(key);
    }

    public byte getIfAbsent(Object key, byte ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(byte value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectByteProcedure<? super K> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectByteMap<K> select(ObjectBytePredicate<? super K> predicate) {
        return this.map.select(predicate);
    }

    public MutableObjectByteMap<K> reject(ObjectBytePredicate<? super K> predicate) {
        return this.map.reject(predicate);
    }

    public ByteIterator byteIterator() {
        return this.map.byteIterator();
    }

    public void forEach(ByteProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableByteCollection select(BytePredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableByteCollection reject(BytePredicate predicate) {
        return this.map.reject(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(ByteToObjectFunction<? extends V1> function) {
        return this.map.collect(function);
    }

    public long sum() {
        return this.map.sum();
    }

    public byte max() {
        return this.map.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public byte min() {
        return this.map.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public byte[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return this.map.toSortedList();
    }

    public byte[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(byte value) {
        return this.map.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.map.containsAll(source);
    }

    public MutableByteList toList() {
        return this.map.toList();
    }

    public MutableByteSet toSet() {
        return this.map.toSet();
    }

    public MutableByteBag toBag() {
        return this.map.toBag();
    }

    public LazyByteIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableObjectByteMap<K> withKeyValue(K key, byte value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectByteMap<K> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectByteMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectByteMap<K> asUnmodifiable() {
        return this;
    }

    public MutableObjectByteMap<K> asSynchronized() {
        return new SynchronizedObjectByteMap(this);
    }

    public ImmutableObjectByteMap<K> toImmutable() {
        return ObjectByteMaps.immutable.withAll((ObjectByteMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public Set<K> keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableByteCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }
}

