/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.factory.primitive.ByteSets;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableByteSetSerializationProxy;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedByteSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteHashSet
implements MutableByteSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final byte EMPTY = 0;
    private static final byte REMOVED = 1;
    private byte[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public ByteHashSet() {
        this.allocateTable(16);
    }

    public ByteHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public ByteHashSet(ByteHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    public static ByteHashSet newSet(ByteIterable source) {
        if (source instanceof ByteHashSet) {
            return new ByteHashSet((ByteHashSet)source);
        }
        return ByteHashSet.newSetWith(source.toArray());
    }

    public static ByteHashSet newSetWith(byte ... source) {
        ByteHashSet result = new ByteHashSet();
        result.addAll(source);
        return result;
    }

    private static boolean isBetweenZeroAndThirtyOne(byte value) {
        return value >= 0 && value <= 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteSet)) {
            return false;
        }
        ByteSet other = (ByteSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    public int hashCode() {
        byte value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += value;
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!ByteHashSet.isNonSentinel(this.table[i])) continue;
                result += this.table[i];
            }
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            byte value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean add(byte element) {
        if (ByteHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (this.table[index] == element) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (this.table[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    public boolean addAll(byte ... source) {
        int oldSize = this.size();
        for (byte item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    public boolean addAll(ByteIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ByteHashSet) {
            ByteHashSet hashSet = (ByteHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (byte item : hashSet.table) {
                if (!ByteHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                byte item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean remove(byte value) {
        if (ByteHashSet.isBetweenZeroAndThirtyOne(value)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne &= ~(1 << value);
            if (this.zeroToThirtyOne == initial) {
                return false;
            }
            --this.zeroToThirtyOneOccupied;
            return true;
        }
        int index = this.probe(value);
        if (this.table[index] == value) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(ByteIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ByteHashSet) {
            ByteHashSet hashSet = (ByteHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (byte item : hashSet.table) {
                if (!ByteHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                byte item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(byte ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (byte item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new byte[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, (byte)0);
        }
    }

    public ByteHashSet with(byte element) {
        this.add(element);
        return this;
    }

    public ByteHashSet without(byte element) {
        this.remove(element);
        return this;
    }

    public ByteHashSet withAll(ByteIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    public ByteHashSet withoutAll(ByteIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public MutableByteSet asUnmodifiable() {
        return new UnmodifiableByteSet(this);
    }

    public MutableByteSet asSynchronized() {
        return new SynchronizedByteSet(this);
    }

    public ImmutableByteSet toImmutable() {
        if (this.size() == 0) {
            return ByteSets.immutable.with();
        }
        if (this.size() == 1) {
            return ByteSets.immutable.with(this.byteIterator().next());
        }
        ByteHashSet mutableSet = ByteHashSet.newSetWith(this.toArray());
        return new ImmutableByteHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    public ByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public byte[] toArray() {
        byte value;
        byte[] array = new byte[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            array[j] = value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!ByteHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    public boolean contains(byte value) {
        if (ByteHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> value & 1) != 0;
        }
        return this.table[this.probe(value)] == value;
    }

    public boolean containsAll(byte ... source) {
        for (byte item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void forEach(ByteProcedure procedure) {
        byte value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    public ByteHashSet select(BytePredicate predicate) {
        byte value;
        ByteHashSet result = new ByteHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            result.add(value);
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public MutableByteSet reject(BytePredicate predicate) {
        byte value;
        ByteHashSet result = new ByteHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            result.add(value);
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
        byte value;
        UnifiedSet target = UnifiedSet.newSet(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        byte value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    public int count(BytePredicate predicate) {
        byte value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        byte value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        byte value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        byte value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return false;
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteArrayList.newList((ByteIterable)this);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet((ByteIterable)this);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag((ByteIterable)this);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public long sum() {
        byte value;
        long result = 0L;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (long)value;
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2)) continue;
            result += (long)value2;
        }
        return result;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte max = (byte)(31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne));
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (byte value : this.table) {
            if (!ByteHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte min = (byte)Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (byte value : this.table) {
            if (!ByteHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    public ByteSet freeze() {
        if (this.size() == 0) {
            return ByteSets.immutable.with();
        }
        if (this.size() == 1) {
            return ByteSets.immutable.with(this.byteIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableByteHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeByte(value);
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2)) continue;
            out.writeByte(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readByte());
        }
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        byte value;
        Object result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (byte value2 : this.table) {
            if (!ByteHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.table.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.table.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        byte[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    private void allocateTable(int sizeToAllocate) {
        this.table = new byte[sizeToAllocate];
    }

    int probe(byte element) {
        int index = this.spread(element);
        byte valueAtIndex = this.table[index];
        if (valueAtIndex == element || valueAtIndex == 0) {
            return index;
        }
        int removedIndex = valueAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex = nextIndex + probe & this.table.length - 1;
            probe += 17;
            if (this.table[nextIndex] == element) {
                return nextIndex;
            }
            if (this.table[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.table[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(byte element) {
        return element & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        byte[] copy = new byte[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, Math.min(this.table.length, this.table.length));
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        int capacity = this.table.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.table.length / 4;
    }

    private static boolean isNonSentinel(byte value) {
        return value != 0 && value != 1;
    }

    private class InternalByteIterator
    implements ByteIterator {
        private int count;
        private int position;
        private byte zeroToThirtyOne;

        private InternalByteIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteHashSet.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32) {
                if (ByteHashSet.this.contains(this.zeroToThirtyOne)) {
                    byte result = this.zeroToThirtyOne;
                    this.zeroToThirtyOne = (byte)(this.zeroToThirtyOne + 1);
                    return result;
                }
                this.zeroToThirtyOne = (byte)(this.zeroToThirtyOne + 1);
            }
            byte[] table = ByteHashSet.this.table;
            while (!ByteHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            byte result = table[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImmutableByteHashSet
    implements ImmutableByteSet,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableByteHashSet(byte[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use ByteSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableByteSet newSetWith(byte ... elements) {
            return ByteHashSet.newSetWith(elements).toImmutable();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteSet)) {
                return false;
            }
            ByteSet other = (ByteSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            byte value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += value;
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!ByteHashSet.isNonSentinel(this.table[i])) continue;
                    result += this.table[i];
                }
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public ImmutableByteSet newWith(byte element) {
            return ByteHashSet.newSet((ByteIterable)this).with(element).toImmutable();
        }

        public ImmutableByteSet newWithout(byte element) {
            return ByteHashSet.newSet((ByteIterable)this).without(element).toImmutable();
        }

        public ImmutableByteSet newWithAll(ByteIterable elements) {
            return ByteHashSet.newSet((ByteIterable)this).withAll(elements).toImmutable();
        }

        public ImmutableByteSet newWithoutAll(ByteIterable elements) {
            return ByteHashSet.newSet((ByteIterable)this).withoutAll(elements).toImmutable();
        }

        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean notEmpty() {
            return this.size() != 0;
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                byte value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                    value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (byte value2 : this.table) {
                    if (!ByteHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteIterator byteIterator() {
            return new InternalByteIterator();
        }

        public byte[] toArray() {
            byte value;
            byte[] array = new byte[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                array[j] = value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!ByteHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        public boolean contains(byte value) {
            if (ByteHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> value & 1) != 0;
            }
            return this.table[this.probe(value)] == value;
        }

        public boolean containsAll(byte ... source) {
            for (byte item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ByteIterable source) {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public void forEach(ByteProcedure procedure) {
            byte value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        public ImmutableByteSet select(BytePredicate predicate) {
            byte value;
            ByteHashSet result = new ByteHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                result.add(value);
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public ImmutableByteSet reject(BytePredicate predicate) {
            byte value;
            ByteHashSet result = new ByteHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                result.add(value);
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public <V> ImmutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
            byte value;
            UnifiedSet target = UnifiedSet.newSet(this.size());
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                target.add(function.valueOf(value));
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2)) continue;
                target.add(function.valueOf(value2));
            }
            return target.toImmutable();
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            byte value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        public int count(BytePredicate predicate) {
            byte value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(BytePredicate predicate) {
            byte value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(BytePredicate predicate) {
            byte value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            byte value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return false;
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public MutableByteList toList() {
            return ByteArrayList.newList((ByteIterable)this);
        }

        public MutableByteSet toSet() {
            return ByteHashSet.newSet((ByteIterable)this);
        }

        public MutableByteBag toBag() {
            return ByteHashBag.newBag((ByteIterable)this);
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public long sum() {
            byte value;
            long result = 0L;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (long)value;
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2)) continue;
                result += (long)value2;
            }
            return result;
        }

        public byte max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte max = (byte)(31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne));
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (byte value : this.table) {
                if (!ByteHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        public byte maxIfEmpty(byte defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public byte min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte min = (byte)Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (byte value : this.table) {
                if (!ByteHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        public byte minIfEmpty(byte defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableByteList toSortedList() {
            return ByteArrayList.newList((ByteIterable)this).sortThis();
        }

        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            byte value;
            Object result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (byte)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (byte value2 : this.table) {
                if (!ByteHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        public ByteSet freeze() {
            return this;
        }

        public ImmutableByteSet toImmutable() {
            return this;
        }

        private Object writeReplace() {
            return new ImmutableByteSetSerializationProxy((ByteSet)this);
        }

        int probe(byte element) {
            int index = this.spread(element);
            byte valueAtIndex = this.table[index];
            if (valueAtIndex == element || valueAtIndex == 0) {
                return index;
            }
            int removedIndex = valueAtIndex == 1 ? index : -1;
            int nextIndex = index;
            int probe = 17;
            while (true) {
                nextIndex = nextIndex + probe & this.table.length - 1;
                probe += 17;
                if (this.table[nextIndex] == element) {
                    return nextIndex;
                }
                if (this.table[nextIndex] == 1) {
                    if (removedIndex != -1) continue;
                    removedIndex = nextIndex;
                    continue;
                }
                if (this.table[nextIndex] == 0) break;
            }
            return removedIndex == -1 ? nextIndex : removedIndex;
        }

        int spread(byte element) {
            return element & this.table.length - 1;
        }

        private class InternalByteIterator
        implements ByteIterator {
            private int count;
            private int position;
            private byte zeroToThirtyOne;

            private InternalByteIterator() {
            }

            public boolean hasNext() {
                return this.count < ImmutableByteHashSet.this.size();
            }

            public byte next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32) {
                    if (ImmutableByteHashSet.this.contains(this.zeroToThirtyOne)) {
                        byte result = this.zeroToThirtyOne;
                        this.zeroToThirtyOne = (byte)(this.zeroToThirtyOne + 1);
                        return result;
                    }
                    this.zeroToThirtyOne = (byte)(this.zeroToThirtyOne + 1);
                }
                byte[] table = ImmutableByteHashSet.this.table;
                while (!ByteHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                byte result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }
}

