/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.strategy.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.set.PartitionMutableSet;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.Pool;
import com.gs.collections.api.set.SetIterable;
import com.gs.collections.api.set.UnsortedSetIterable;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Predicates2;
import com.gs.collections.impl.block.procedure.CollectIfProcedure;
import com.gs.collections.impl.block.procedure.CollectProcedure;
import com.gs.collections.impl.block.procedure.CountProcedure;
import com.gs.collections.impl.block.procedure.FlatCollectProcedure;
import com.gs.collections.impl.block.procedure.MultimapEachPutProcedure;
import com.gs.collections.impl.block.procedure.MultimapPutProcedure;
import com.gs.collections.impl.block.procedure.PartitionProcedure;
import com.gs.collections.impl.block.procedure.RejectProcedure;
import com.gs.collections.impl.block.procedure.SelectInstancesOfProcedure;
import com.gs.collections.impl.block.procedure.SelectProcedure;
import com.gs.collections.impl.block.procedure.ZipWithIndexProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectByteProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectCharProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectIntProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectLongProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectShortProcedure;
import com.gs.collections.impl.factory.HashingStrategySets;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.multimap.set.UnifiedSetMultimap;
import com.gs.collections.impl.multimap.set.strategy.UnifiedSetWithHashingStrategyMultimap;
import com.gs.collections.impl.parallel.BatchIterable;
import com.gs.collections.impl.partition.set.strategy.PartitionUnifiedSetWithHashingStrategy;
import com.gs.collections.impl.set.mutable.SynchronizedMutableSet;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.UnmodifiableMutableSet;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.utility.ArrayIterate;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import com.gs.collections.impl.utility.internal.MutableCollectionIterate;
import com.gs.collections.impl.utility.internal.SetIterables;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class UnifiedSetWithHashingStrategy<K>
implements MutableSet<K>,
Externalizable,
Pool<K>,
BatchIterable<K> {
    protected static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "UnifiedSetWithHashingStrategy.NULL_KEY";
        }
    };
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 1L;
    protected transient Object[] table;
    protected transient int occupied;
    protected float loadFactor = 0.75f;
    protected int maxSize;
    private HashingStrategy<? super K> hashingStrategy;

    @Deprecated
    public UnifiedSetWithHashingStrategy() {
    }

    public UnifiedSetWithHashingStrategy(HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException("Cannot Instantiate UnifiedSetWithHashingStrategy with null HashingStrategy");
        }
        this.hashingStrategy = hashingStrategy;
        this.allocate(16);
    }

    public UnifiedSetWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        this(hashingStrategy, initialCapacity, 0.75f);
    }

    public UnifiedSetWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.hashingStrategy = hashingStrategy;
        this.loadFactor = loadFactor;
        this.init(this.fastCeil((float)initialCapacity / loadFactor));
    }

    public UnifiedSetWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, Collection<? extends K> collection) {
        this(hashingStrategy, Math.max(collection.size(), 8), 0.75f);
        this.addAll(collection);
    }

    public UnifiedSetWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, UnifiedSetWithHashingStrategy<K> set) {
        this.hashingStrategy = hashingStrategy;
        this.maxSize = set.maxSize;
        this.loadFactor = set.loadFactor;
        this.occupied = set.occupied;
        this.allocateTable(set.table.length);
        for (int i = 0; i < set.table.length; ++i) {
            Object key = set.table[i];
            if (key instanceof ChainedBucket) {
                this.table[i] = ((ChainedBucket)key).copy();
                continue;
            }
            if (key == null) continue;
            this.table[i] = key;
        }
    }

    public static <K> UnifiedSetWithHashingStrategy<K> newSet(HashingStrategy<? super K> hashingStrategy) {
        return new UnifiedSetWithHashingStrategy<K>(hashingStrategy);
    }

    public static <K> UnifiedSetWithHashingStrategy<K> newSet(UnifiedSetWithHashingStrategy<K> set) {
        return new UnifiedSetWithHashingStrategy<K>(set.hashingStrategy, set);
    }

    public static <K> UnifiedSetWithHashingStrategy<K> newSet(HashingStrategy<? super K> hashingStrategy, int size) {
        return new UnifiedSetWithHashingStrategy<K>(hashingStrategy, size);
    }

    /*
     * Exception decompiling
     */
    public static <K> UnifiedSetWithHashingStrategy<K> newSet(HashingStrategy<? super K> hashingStrategy, Iterable<? extends K> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <K> UnifiedSetWithHashingStrategy<K> newSet(HashingStrategy<? super K> hashingStrategy, int size, float loadFactor) {
        return new UnifiedSetWithHashingStrategy<K>(hashingStrategy, size, loadFactor);
    }

    public static <K> UnifiedSetWithHashingStrategy<K> newSetWith(HashingStrategy<? super K> hashingStrategy, K ... elements) {
        return UnifiedSetWithHashingStrategy.newSet(hashingStrategy, elements.length).with(elements);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    protected int init(int initialCapacity) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        return this.allocate(capacity);
    }

    protected int allocate(int capacity) {
        this.allocateTable(capacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.table = new Object[sizeToAllocate];
    }

    protected void computeMaxSize(int capacity) {
        this.maxSize = Math.min(capacity - 1, (int)((float)capacity * this.loadFactor));
    }

    protected final int index(K key) {
        int h = this.hashingStrategy.computeHashCode(key);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.table.length - 1;
    }

    public void clear() {
        if (this.occupied == 0) {
            return;
        }
        this.occupied = 0;
        Object[] set = this.table;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    public boolean add(K key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            this.table[index] = UnifiedSetWithHashingStrategy.toSentinelIfNull(key);
            if (++this.occupied > this.maxSize) {
                this.rehash();
            }
            return true;
        }
        if (cur instanceof ChainedBucket || !this.nonNullTableObjectEquals(cur, key)) {
            return this.chainedAdd(key, index);
        }
        return false;
    }

    private boolean chainedAdd(K key, int index) {
        if (this.table[index] instanceof ChainedBucket) {
            ChainedBucket bucket = (ChainedBucket)this.table[index];
            while (true) {
                if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                    return false;
                }
                if (bucket.one == null) {
                    bucket.one = UnifiedSetWithHashingStrategy.toSentinelIfNull(key);
                    if (++this.occupied > this.maxSize) {
                        this.rehash();
                    }
                    return true;
                }
                if (this.nonNullTableObjectEquals(bucket.one, key)) {
                    return false;
                }
                if (bucket.two == null) {
                    bucket.two = UnifiedSetWithHashingStrategy.toSentinelIfNull(key);
                    if (++this.occupied > this.maxSize) {
                        this.rehash();
                    }
                    return true;
                }
                if (this.nonNullTableObjectEquals(bucket.two, key)) {
                    return false;
                }
                if (!(bucket.three instanceof ChainedBucket)) break;
                bucket = (ChainedBucket)bucket.three;
            }
            if (bucket.three == null) {
                bucket.three = UnifiedSetWithHashingStrategy.toSentinelIfNull(key);
                if (++this.occupied > this.maxSize) {
                    this.rehash();
                }
                return true;
            }
            if (this.nonNullTableObjectEquals(bucket.three, key)) {
                return false;
            }
            bucket.three = new ChainedBucket(bucket.three, UnifiedSetWithHashingStrategy.toSentinelIfNull(key));
            if (++this.occupied > this.maxSize) {
                this.rehash();
            }
            return true;
        }
        ChainedBucket newBucket = new ChainedBucket(this.table[index], UnifiedSetWithHashingStrategy.toSentinelIfNull(key));
        this.table[index] = newBucket;
        if (++this.occupied > this.maxSize) {
            this.rehash();
        }
        return true;
    }

    protected void rehash() {
        this.rehash(this.table.length << 1);
    }

    protected void rehash(int newCapacity) {
        int oldLength = this.table.length;
        Object[] old = this.table;
        this.allocate(newCapacity);
        this.occupied = 0;
        block0: for (int i = 0; i < oldLength; ++i) {
            Object oldKey = old[i];
            if (oldKey instanceof ChainedBucket) {
                ChainedBucket bucket = (ChainedBucket)oldKey;
                while (true) {
                    if (bucket.zero != null) {
                        this.add(this.nonSentinel(bucket.zero));
                    }
                    if (bucket.one == null) continue block0;
                    this.add(this.nonSentinel(bucket.one));
                    if (bucket.two == null) continue block0;
                    this.add(this.nonSentinel(bucket.two));
                    if (bucket.three == null) continue block0;
                    if (!(bucket.three instanceof ChainedBucket)) break;
                    bucket = (ChainedBucket)bucket.three;
                }
                this.add(this.nonSentinel(bucket.three));
                continue;
            }
            if (oldKey == null) continue;
            this.add(this.nonSentinel(oldKey));
        }
    }

    public boolean contains(Object key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return false;
        }
        if (cur instanceof ChainedBucket) {
            return this.chainContains((ChainedBucket)cur, key);
        }
        return this.nonNullTableObjectEquals(cur, key);
    }

    private boolean chainContains(ChainedBucket bucket, K key) {
        while (true) {
            if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                return true;
            }
            if (bucket.one == null) {
                return false;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                return true;
            }
            if (bucket.two == null) {
                return false;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                return true;
            }
            if (bucket.three == null) {
                return false;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        return this.nonNullTableObjectEquals(bucket.three, key);
    }

    @Override
    public int getBatchCount(int batchSize) {
        return Math.max(1, this.table.length / batchSize);
    }

    @Override
    public void batchForEach(Procedure<? super K> procedure, int sectionIndex, int sectionCount) {
        Object[] set = this.table;
        int sectionSize = set.length / sectionCount;
        int start = sectionSize * sectionIndex;
        int end = sectionIndex == sectionCount - 1 ? set.length : start + sectionSize;
        for (int i = start; i < end; ++i) {
            Object cur = set[i];
            if (cur == null) continue;
            if (cur instanceof ChainedBucket) {
                this.chainedForEach((ChainedBucket)cur, procedure);
                continue;
            }
            procedure.value(this.nonSentinel(cur));
        }
    }

    @Override
    public void forEach(Procedure<? super K> procedure) {
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                this.chainedForEach((ChainedBucket)cur, procedure);
                continue;
            }
            if (cur == null) continue;
            procedure.value(this.nonSentinel(cur));
        }
    }

    private void chainedForEach(ChainedBucket bucket, Procedure<? super K> procedure) {
        while (true) {
            procedure.value(this.nonSentinel(bucket.zero));
            if (bucket.one == null) {
                return;
            }
            procedure.value(this.nonSentinel(bucket.one));
            if (bucket.two == null) {
                return;
            }
            procedure.value(this.nonSentinel(bucket.two));
            if (bucket.three == null) {
                return;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        procedure.value(this.nonSentinel(bucket.three));
    }

    public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                this.chainedForEachWith((ChainedBucket)cur, procedure, parameter);
                continue;
            }
            if (cur == null) continue;
            procedure.value(this.nonSentinel(cur), parameter);
        }
    }

    private <P> void chainedForEachWith(ChainedBucket bucket, Procedure2<? super K, ? super P> procedure, P parameter) {
        while (true) {
            procedure.value(this.nonSentinel(bucket.zero), parameter);
            if (bucket.one == null) {
                return;
            }
            procedure.value(this.nonSentinel(bucket.one), parameter);
            if (bucket.two == null) {
                return;
            }
            procedure.value(this.nonSentinel(bucket.two), parameter);
            if (bucket.three == null) {
                return;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        procedure.value(this.nonSentinel(bucket.three), parameter);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super K> objectIntProcedure) {
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                count = this.chainedForEachWithIndex((ChainedBucket)cur, objectIntProcedure, count);
                continue;
            }
            if (cur == null) continue;
            objectIntProcedure.value(this.nonSentinel(cur), count++);
        }
    }

    private int chainedForEachWithIndex(ChainedBucket bucket, ObjectIntProcedure<? super K> procedure, int count) {
        while (true) {
            procedure.value(this.nonSentinel(bucket.zero), count++);
            if (bucket.one == null) {
                return count;
            }
            procedure.value(this.nonSentinel(bucket.one), count++);
            if (bucket.two == null) {
                return count;
            }
            procedure.value(this.nonSentinel(bucket.two), count++);
            if (bucket.three == null) {
                return count;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        procedure.value(this.nonSentinel(bucket.three), count++);
        return count;
    }

    public UnifiedSetWithHashingStrategy<K> newEmpty() {
        return UnifiedSetWithHashingStrategy.newSet(this.hashingStrategy);
    }

    public K getFirst() {
        return this.isEmpty() ? null : (K)this.iterator().next();
    }

    public K getLast() {
        return this.getFirst();
    }

    public UnifiedSetWithHashingStrategy<K> select(Predicate<? super K> predicate) {
        return (UnifiedSetWithHashingStrategy)this.select(predicate, this.newEmpty());
    }

    public <R extends Collection<K>> R select(Predicate<? super K> predicate, R target) {
        this.forEach((Procedure<? super K>)new SelectProcedure<K>(predicate, target));
        return target;
    }

    public <P> UnifiedSetWithHashingStrategy<K> selectWith(Predicate2<? super K, ? super P> predicate, P parameter) {
        return (UnifiedSetWithHashingStrategy)this.selectWith(predicate, parameter, this.newEmpty());
    }

    public <P, R extends Collection<K>> R selectWith(final Predicate2<? super K, ? super P> predicate, P parameter, final R targetCollection) {
        this.forEachWith(new Procedure2<K, P>(){

            public void value(K each, P parm) {
                if (predicate.accept(each, parm)) {
                    targetCollection.add(each);
                }
            }
        }, parameter);
        return targetCollection;
    }

    public UnifiedSetWithHashingStrategy<K> reject(Predicate<? super K> predicate) {
        return (UnifiedSetWithHashingStrategy)this.reject(predicate, this.newEmpty());
    }

    public <R extends Collection<K>> R reject(Predicate<? super K> predicate, R target) {
        this.forEach((Procedure<? super K>)new RejectProcedure<K>(predicate, target));
        return target;
    }

    public <P> UnifiedSetWithHashingStrategy<K> rejectWith(Predicate2<? super K, ? super P> predicate, P parameter) {
        return (UnifiedSetWithHashingStrategy)this.rejectWith(predicate, parameter, this.newEmpty());
    }

    public <P, R extends Collection<K>> R rejectWith(final Predicate2<? super K, ? super P> predicate, P parameter, final R targetCollection) {
        this.forEachWith(new Procedure2<K, P>(){

            public void value(K each, P parm) {
                if (!predicate.accept(each, parm)) {
                    targetCollection.add(each);
                }
            }
        }, parameter);
        return targetCollection;
    }

    public <P> Twin<MutableList<K>> selectAndRejectWith(final Predicate2<? super K, ? super P> predicate, P parameter) {
        final MutableList positiveResult = Lists.mutable.of();
        final MutableList negativeResult = Lists.mutable.of();
        this.forEachWith(new Procedure2<K, P>(){

            public void value(K each, P parm) {
                (predicate.accept(each, parm) ? positiveResult : negativeResult).add(each);
            }
        }, parameter);
        return Tuples.twin(positiveResult, negativeResult);
    }

    public PartitionMutableSet<K> partition(Predicate<? super K> predicate) {
        PartitionUnifiedSetWithHashingStrategy<? super K> partitionMutableSet = new PartitionUnifiedSetWithHashingStrategy<K>(this.hashingStrategy);
        this.forEach((Procedure<? super K>)new PartitionProcedure<K>(predicate, partitionMutableSet));
        return partitionMutableSet;
    }

    public <S> UnifiedSetWithHashingStrategy<S> selectInstancesOf(Class<S> clazz) {
        MutableSet result = this.newEmpty();
        this.forEach((Procedure<? super K>)new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    public void removeIf(Predicate<? super K> predicate) {
        IterableIterate.removeIf(this, predicate);
    }

    public <P> void removeIfWith(Predicate2<? super K, ? super P> predicate, P parameter) {
        IterableIterate.removeIfWith(this, predicate, parameter);
    }

    public <V> UnifiedSet<V> collect(Function<? super K, ? extends V> function) {
        return this.collect(function, (Collection)((Object)UnifiedSet.newSet()));
    }

    public MutableBooleanSet collectBoolean(BooleanFunction<? super K> booleanFunction) {
        BooleanHashSet result = new BooleanHashSet();
        this.forEach((Procedure<? super K>)new CollectBooleanProcedure<K>(booleanFunction, (MutableBooleanCollection)result));
        return result;
    }

    public MutableByteSet collectByte(ByteFunction<? super K> byteFunction) {
        ByteHashSet result = new ByteHashSet();
        this.forEach((Procedure<? super K>)new CollectByteProcedure<K>(byteFunction, (MutableByteCollection)result));
        return result;
    }

    public MutableCharSet collectChar(CharFunction<? super K> charFunction) {
        CharHashSet result = new CharHashSet();
        this.forEach((Procedure<? super K>)new CollectCharProcedure<K>(charFunction, (MutableCharCollection)result));
        return result;
    }

    public MutableDoubleSet collectDouble(DoubleFunction<? super K> doubleFunction) {
        DoubleHashSet result = new DoubleHashSet();
        this.forEach((Procedure<? super K>)new CollectDoubleProcedure<K>(doubleFunction, (MutableDoubleCollection)result));
        return result;
    }

    public MutableFloatSet collectFloat(FloatFunction<? super K> floatFunction) {
        FloatHashSet result = new FloatHashSet();
        this.forEach((Procedure<? super K>)new CollectFloatProcedure<K>(floatFunction, (MutableFloatCollection)result));
        return result;
    }

    public MutableIntSet collectInt(IntFunction<? super K> intFunction) {
        IntHashSet result = new IntHashSet();
        this.forEach((Procedure<? super K>)new CollectIntProcedure<K>(intFunction, (MutableIntCollection)result));
        return result;
    }

    public MutableLongSet collectLong(LongFunction<? super K> longFunction) {
        LongHashSet result = new LongHashSet(this.size());
        this.forEach((Procedure<? super K>)new CollectLongProcedure<K>(longFunction, (MutableLongCollection)result));
        return result;
    }

    public MutableShortSet collectShort(ShortFunction<? super K> shortFunction) {
        ShortHashSet result = new ShortHashSet(this.size());
        this.forEach((Procedure<? super K>)new CollectShortProcedure<K>(shortFunction, (MutableShortCollection)result));
        return result;
    }

    public <V, R extends Collection<V>> R collect(Function<? super K, ? extends V> function, R target) {
        this.forEach((Procedure<? super K>)new CollectProcedure<K, V>(function, target));
        return target;
    }

    public <V> UnifiedSet<V> flatCollect(Function<? super K, ? extends Iterable<V>> function) {
        return this.flatCollect(function, (Collection)((Object)UnifiedSet.newSet()));
    }

    public <V, R extends Collection<V>> R flatCollect(Function<? super K, ? extends Iterable<V>> function, R target) {
        this.forEach(new FlatCollectProcedure(function, target));
        return target;
    }

    public <P, A> UnifiedSet<A> collectWith(Function2<? super K, ? super P, ? extends A> function, P parameter) {
        return this.collectWith(function, parameter, (Collection)((Object)UnifiedSet.newSet()));
    }

    public <P, A, R extends Collection<A>> R collectWith(final Function2<? super K, ? super P, ? extends A> function, P parameter, final R targetCollection) {
        this.forEachWith(new Procedure2<K, P>(){

            public void value(K each, P parm) {
                targetCollection.add(function.value(each, parm));
            }
        }, parameter);
        return targetCollection;
    }

    public <V> UnifiedSet<V> collectIf(Predicate<? super K> predicate, Function<? super K, ? extends V> function) {
        return this.collectIf(predicate, function, (Collection)((Object)UnifiedSet.newSet()));
    }

    public <V, R extends Collection<V>> R collectIf(Predicate<? super K> predicate, Function<? super K, ? extends V> function, R target) {
        this.forEach((Procedure<? super K>)new CollectIfProcedure<K, V>(target, function, predicate));
        return target;
    }

    public K detect(Predicate<? super K> predicate) {
        return IterableIterate.detect(this, predicate);
    }

    public K min(Comparator<? super K> comparator) {
        return Iterate.min(this, comparator);
    }

    public K max(Comparator<? super K> comparator) {
        return Iterate.max(this, comparator);
    }

    public K min() {
        return (K)Iterate.min(this);
    }

    public K max() {
        return (K)Iterate.max(this);
    }

    public <V extends Comparable<? super V>> K minBy(Function<? super K, ? extends V> function) {
        return IterableIterate.minBy(this, function);
    }

    public <V extends Comparable<? super V>> K maxBy(Function<? super K, ? extends V> function) {
        return IterableIterate.maxBy(this, function);
    }

    public K detectIfNone(Predicate<? super K> predicate, Function0<? extends K> function) {
        K result = this.detect(predicate);
        return (K)(result == null ? function.value() : result);
    }

    public <P> K detectWith(Predicate2<? super K, ? super P> predicate, P parameter) {
        return IterableIterate.detectWith(this, predicate, parameter);
    }

    public <P> K detectWithIfNone(Predicate2<? super K, ? super P> predicate, P parameter, Function0<? extends K> function) {
        K result = this.detectWith(predicate, parameter);
        return (K)(result == null ? function.value() : result);
    }

    public int count(Predicate<? super K> predicate) {
        CountProcedure<K> procedure = new CountProcedure<K>(predicate);
        this.forEach((Procedure<? super K>)procedure);
        return procedure.getCount();
    }

    public <P> int countWith(final Predicate2<? super K, ? super P> predicate, P parameter) {
        final Counter count = new Counter();
        this.forEachWith(new Procedure2<K, P>(){

            public void value(K each, P parm) {
                if (predicate.accept(each, parm)) {
                    count.increment();
                }
            }
        }, parameter);
        return count.getCount();
    }

    public boolean anySatisfy(Predicate<? super K> predicate) {
        return IterableIterate.anySatisfy(this, predicate);
    }

    public <P> boolean anySatisfyWith(Predicate2<? super K, ? super P> predicate, P parameter) {
        return IterableIterate.anySatisfyWith(this, predicate, parameter);
    }

    public boolean allSatisfy(Predicate<? super K> predicate) {
        return IterableIterate.allSatisfy(this, predicate);
    }

    public <P> boolean allSatisfyWith(Predicate2<? super K, ? super P> predicate, P parameter) {
        return IterableIterate.allSatisfyWith(this, predicate, parameter);
    }

    public boolean noneSatisfy(Predicate<? super K> predicate) {
        return IterableIterate.noneSatisfy(this, predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super K, ? super P> predicate, P parameter) {
        return IterableIterate.noneSatisfyWith(this, predicate, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super K, ? extends IV> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super K> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super K> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super K> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super K> function) {
        return IterableIterate.injectInto(injectedValue, this, function);
    }

    public long sumOfInt(IntFunction<? super K> function) {
        return IterableIterate.sumOfInt(this, function);
    }

    public double sumOfFloat(FloatFunction<? super K> function) {
        return IterableIterate.sumOfFloat(this, function);
    }

    public long sumOfLong(LongFunction<? super K> function) {
        return IterableIterate.sumOfLong(this, function);
    }

    public double sumOfDouble(DoubleFunction<? super K> function) {
        return IterableIterate.sumOfDouble(this, function);
    }

    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super K, ? super P, ? extends IV> function, P parameter) {
        return IterableIterate.injectIntoWith(injectValue, this, function, parameter);
    }

    @Deprecated
    public LazyIterable<K> lazySelect(Predicate<? super K> predicate) {
        return this.asLazy().select(predicate);
    }

    @Deprecated
    public LazyIterable<K> lazyReject(Predicate<? super K> predicate) {
        return this.asLazy().reject(predicate);
    }

    @Deprecated
    public <V> LazyIterable<V> lazyCollect(Function<? super K, ? extends V> function) {
        return this.asLazy().collect(function);
    }

    public MutableList<K> toList() {
        return FastList.newList(this);
    }

    public MutableList<K> toSortedList() {
        return FastList.newList(this).sortThis();
    }

    public MutableList<K> toSortedList(Comparator<? super K> comparator) {
        return FastList.newList(this).sortThis(comparator);
    }

    public <V extends Comparable<? super V>> MutableList<K> toSortedListBy(Function<? super K, ? extends V> function) {
        return this.toSortedList((Comparator<? super K>)Comparators.byFunction(function));
    }

    public MutableSortedSet<K> toSortedSet() {
        return TreeSortedSet.newSet(null, this);
    }

    public MutableSortedSet<K> toSortedSet(Comparator<? super K> comparator) {
        return TreeSortedSet.newSet(comparator, this);
    }

    public <V extends Comparable<? super V>> MutableSortedSet<K> toSortedSetBy(Function<? super K, ? extends V> function) {
        return this.toSortedSet((Comparator<? super K>)Comparators.byFunction(function));
    }

    public UnifiedSet<K> toSet() {
        return UnifiedSet.newSet(this);
    }

    public MutableBag<K> toBag() {
        return HashBag.newBag(this);
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super K, ? extends NK> keyFunction, Function<? super K, ? extends NV> valueFunction) {
        return UnifiedMap.newMap(this.size()).collectKeysAndValues(this, keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super K, ? extends NK> keyFunction, Function<? super K, ? extends NV> valueFunction) {
        return TreeSortedMap.newMap().collectKeysAndValues(this, keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super K, ? extends NK> keyFunction, Function<? super K, ? extends NV> valueFunction) {
        return TreeSortedMap.newMap(comparator).collectKeysAndValues(this, keyFunction, valueFunction);
    }

    public LazyIterable<K> asLazy() {
        return LazyIterate.adapt(this);
    }

    public MutableSet<K> asUnmodifiable() {
        return UnmodifiableMutableSet.of(this);
    }

    public MutableSet<K> asSynchronized() {
        return SynchronizedMutableSet.of(this);
    }

    public ImmutableSet<K> toImmutable() {
        return HashingStrategySets.immutable.ofAll(this.hashingStrategy, (Iterable)((Object)this));
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.occupied == 0;
    }

    public UnifiedSetWithHashingStrategy<K> with(K element) {
        this.add(element);
        return this;
    }

    public UnifiedSetWithHashingStrategy<K> with(K element1, K element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public UnifiedSetWithHashingStrategy<K> with(K element1, K element2, K element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public UnifiedSetWithHashingStrategy<K> with(K ... elements) {
        this.addAll(Arrays.asList(elements));
        return this;
    }

    public UnifiedSetWithHashingStrategy<K> withAll(Iterable<? extends K> iterable) {
        this.addAllIterable(iterable);
        return this;
    }

    public UnifiedSetWithHashingStrategy<K> without(K element) {
        this.remove(element);
        return this;
    }

    public UnifiedSetWithHashingStrategy<K> withoutAll(Iterable<? extends K> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    public boolean addAll(Collection<? extends K> collection) {
        return this.addAllIterable(collection);
    }

    /*
     * Exception decompiling
     */
    public boolean addAllIterable(Iterable<? extends K> iterable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ensureCapacity(int size) {
        if (size > this.maxSize) {
            int capacity = Integer.highestOneBit(size);
            if ((size = (int)((float)size / this.loadFactor) + 1) != capacity) {
                capacity <<= 1;
            }
            this.rehash(capacity);
        }
    }

    protected boolean copySet(UnifiedSetWithHashingStrategy<?> unifiedset) {
        boolean changed = false;
        for (int i = 0; i < unifiedset.table.length; ++i) {
            Object cur = unifiedset.table[i];
            if (cur instanceof ChainedBucket) {
                changed |= this.copyChain((ChainedBucket)cur);
                continue;
            }
            if (cur == null) continue;
            changed |= this.add(this.nonSentinel(cur));
        }
        return changed;
    }

    private boolean copyChain(ChainedBucket bucket) {
        boolean changed = false;
        while (true) {
            changed |= this.add(this.nonSentinel(bucket.zero));
            if (bucket.one == null) {
                return changed;
            }
            changed |= this.add(this.nonSentinel(bucket.one));
            if (bucket.two == null) {
                return changed;
            }
            changed |= this.add(this.nonSentinel(bucket.two));
            if (bucket.three == null) {
                return changed;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        return changed |= this.add(this.nonSentinel(bucket.three));
    }

    public boolean remove(Object key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return false;
        }
        if (cur instanceof ChainedBucket) {
            return this.removeFromChain((ChainedBucket)cur, key, index);
        }
        if (this.nonNullTableObjectEquals(cur, key)) {
            this.table[index] = null;
            --this.occupied;
            return true;
        }
        return false;
    }

    private boolean removeFromChain(ChainedBucket bucket, K key, int index) {
        if (this.nonNullTableObjectEquals(bucket.zero, key)) {
            bucket.zero = bucket.removeLast(0);
            if (bucket.zero == null) {
                this.table[index] = null;
            }
            --this.occupied;
            return true;
        }
        if (bucket.one == null) {
            return false;
        }
        if (this.nonNullTableObjectEquals(bucket.one, key)) {
            bucket.one = bucket.removeLast(1);
            --this.occupied;
            return true;
        }
        if (bucket.two == null) {
            return false;
        }
        if (this.nonNullTableObjectEquals(bucket.two, key)) {
            bucket.two = bucket.removeLast(2);
            --this.occupied;
            return true;
        }
        if (bucket.three == null) {
            return false;
        }
        if (bucket.three instanceof ChainedBucket) {
            return this.removeDeepChain(bucket, key);
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            bucket.three = bucket.removeLast(3);
            --this.occupied;
            return true;
        }
        return false;
    }

    private boolean removeDeepChain(ChainedBucket oldBucket, K key) {
        ChainedBucket bucket;
        while (true) {
            if (this.nonNullTableObjectEquals((bucket = (ChainedBucket)oldBucket.three).zero, key)) {
                bucket.zero = bucket.removeLast(0);
                if (bucket.zero == null) {
                    oldBucket.three = null;
                }
                --this.occupied;
                return true;
            }
            if (bucket.one == null) {
                return false;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                bucket.one = bucket.removeLast(1);
                --this.occupied;
                return true;
            }
            if (bucket.two == null) {
                return false;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                bucket.two = bucket.removeLast(2);
                --this.occupied;
                return true;
            }
            if (bucket.three == null) {
                return false;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            oldBucket = bucket;
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            bucket.three = bucket.removeLast(3);
            --this.occupied;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.occupied;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Object cur = this.table[i];
            if (cur instanceof ChainedBucket) {
                hashCode += this.chainedHashCode((ChainedBucket)cur);
                continue;
            }
            if (cur == null) continue;
            hashCode += this.hashingStrategy.computeHashCode(this.nonSentinel(cur));
        }
        return hashCode;
    }

    private int chainedHashCode(ChainedBucket bucket) {
        int hashCode = 0;
        while (true) {
            hashCode += this.hashingStrategy.computeHashCode(this.nonSentinel(bucket.zero));
            if (bucket.one == null) {
                return hashCode;
            }
            hashCode += this.hashingStrategy.computeHashCode(this.nonSentinel(bucket.one));
            if (bucket.two == null) {
                return hashCode;
            }
            hashCode += this.hashingStrategy.computeHashCode(this.nonSentinel(bucket.two));
            if (bucket.three == null) {
                return hashCode;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        return hashCode += this.hashingStrategy.computeHashCode(this.nonSentinel(bucket.three));
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashingStrategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        this.loadFactor = in.readFloat();
        this.init(Math.max((int)((float)size / this.loadFactor) + 1, 8));
        for (int i = 0; i < size; ++i) {
            this.add(in.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.size());
        out.writeFloat(this.loadFactor);
        for (int i = 0; i < this.table.length; ++i) {
            Object o = this.table[i];
            if (o == null) continue;
            if (o instanceof ChainedBucket) {
                this.writeExternalChain(out, (ChainedBucket)o);
                continue;
            }
            out.writeObject(this.nonSentinel(o));
        }
    }

    private void writeExternalChain(ObjectOutput out, ChainedBucket bucket) throws IOException {
        while (true) {
            out.writeObject(this.nonSentinel(bucket.zero));
            if (bucket.one == null) {
                return;
            }
            out.writeObject(this.nonSentinel(bucket.one));
            if (bucket.two == null) {
                return;
            }
            out.writeObject(this.nonSentinel(bucket.two));
            if (bucket.three == null) {
                return;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        out.writeObject(this.nonSentinel(bucket.three));
    }

    public boolean containsAll(Collection<?> collection) {
        return Iterate.allSatisfyWith(collection, Predicates2.in(), this);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        return Iterate.allSatisfyWith(source, Predicates2.in(), this);
    }

    public boolean containsAllArguments(Object ... elements) {
        return ArrayIterate.allSatisfyWith(elements, Predicates2.in(), this);
    }

    public boolean removeAll(Collection<?> collection) {
        return this.removeAllIterable(collection);
    }

    public boolean removeAllIterable(Iterable<?> iterable) {
        boolean changed = false;
        for (Object each : iterable) {
            changed |= this.remove(each);
        }
        return changed;
    }

    private void addIfFound(K key, UnifiedSetWithHashingStrategy<K> other) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return;
        }
        if (cur instanceof ChainedBucket) {
            this.addIfFoundFromChain((ChainedBucket)cur, key, other);
            return;
        }
        if (this.nonNullTableObjectEquals(cur, key)) {
            other.add(this.nonSentinel(cur));
        }
    }

    private void addIfFoundFromChain(ChainedBucket bucket, K key, UnifiedSetWithHashingStrategy<K> other) {
        while (true) {
            if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                other.add(this.nonSentinel(bucket.zero));
                return;
            }
            if (bucket.one == null) {
                return;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                other.add(this.nonSentinel(bucket.one));
                return;
            }
            if (bucket.two == null) {
                return;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                other.add(this.nonSentinel(bucket.two));
                return;
            }
            if (bucket.three == null) {
                return;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            other.add(this.nonSentinel(bucket.three));
            return;
        }
    }

    public boolean retainAll(Collection<?> collection) {
        return this.retainAllIterable(collection);
    }

    public boolean retainAllIterable(Iterable<?> iterable) {
        if (iterable instanceof Set) {
            return this.retainAllFromSet((Set)iterable);
        }
        return this.retainAllFromNonSet(iterable);
    }

    private boolean retainAllFromNonSet(Iterable<?> iterable) {
        int retainedSize = Iterate.sizeOf(iterable);
        UnifiedSetWithHashingStrategy<K> retainedCopy = new UnifiedSetWithHashingStrategy<K>(this.hashingStrategy, retainedSize, this.loadFactor);
        for (Object key : iterable) {
            this.addIfFound(key, retainedCopy);
        }
        if (retainedCopy.size() < this.size()) {
            this.maxSize = retainedCopy.maxSize;
            this.occupied = retainedCopy.occupied;
            this.table = retainedCopy.table;
            return true;
        }
        return false;
    }

    private boolean retainAllFromSet(Set<?> collection) {
        boolean result = false;
        Iterator<K> e = this.iterator();
        while (e.hasNext()) {
            if (collection.contains(e.next())) continue;
            e.remove();
            result = true;
        }
        return result;
    }

    public UnifiedSetWithHashingStrategy<K> clone() {
        return new UnifiedSetWithHashingStrategy<K>(this.hashingStrategy, this);
    }

    public Object[] toArray() {
        Object[] result = new Object[this.occupied];
        this.copyToArray(result);
        return result;
    }

    private void copyToArray(Object[] result) {
        Object[] table = this.table;
        int count = 0;
        for (int i = 0; i < table.length; ++i) {
            Object cur = table[i];
            if (cur == null) continue;
            if (cur instanceof ChainedBucket) {
                ChainedBucket bucket = (ChainedBucket)cur;
                count = this.copyBucketToArray(result, bucket, count);
                continue;
            }
            result[count++] = this.nonSentinel(cur);
        }
    }

    private int copyBucketToArray(Object[] result, ChainedBucket bucket, int count) {
        block1: {
            while (true) {
                result[count++] = this.nonSentinel(bucket.zero);
                if (bucket.one == null) break block1;
                result[count++] = this.nonSentinel(bucket.one);
                if (bucket.two == null) break block1;
                result[count++] = this.nonSentinel(bucket.two);
                if (bucket.three == null) break block1;
                if (!(bucket.three instanceof ChainedBucket)) break;
                bucket = (ChainedBucket)bucket.three;
            }
            result[count++] = this.nonSentinel(bucket.three);
        }
        return count;
    }

    public <T> T[] toArray(T[] array) {
        int size = this.size();
        Object[] result = array.length < size ? (Object[])Array.newInstance(array.getClass().getComponentType(), size) : array;
        this.copyToArray(result);
        if (size < result.length) {
            result[size] = null;
        }
        return result;
    }

    public Iterator<K> iterator() {
        return new PositionalIterator();
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        IterableIterate.appendString(this, appendable, start, separator, end);
    }

    public <V> UnifiedSetWithHashingStrategyMultimap<V, K> groupBy(Function<? super K, ? extends V> function) {
        return this.groupBy(function, UnifiedSetWithHashingStrategyMultimap.newMultimap(this.hashingStrategy));
    }

    public <V, R extends MutableMultimap<V, K>> R groupBy(Function<? super K, ? extends V> function, R target) {
        this.forEach((Procedure<? super K>)new MultimapPutProcedure<V, K>(target, function));
        return target;
    }

    public <V> UnifiedSetMultimap<V, K> groupByEach(Function<? super K, ? extends Iterable<V>> function) {
        return this.groupByEach(function, UnifiedSetMultimap.newMultimap());
    }

    public <V, R extends MutableMultimap<V, K>> R groupByEach(Function<? super K, ? extends Iterable<V>> function, R target) {
        this.forEach(new MultimapEachPutProcedure(target, function));
        return target;
    }

    public <S> MutableSet<Pair<K, S>> zip(Iterable<S> that) {
        return this.zip(that, (Collection)((Object)UnifiedSet.newSet()));
    }

    public <S, R extends Collection<Pair<K, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    public MutableSet<Pair<K, Integer>> zipWithIndex() {
        return this.zipWithIndex((Collection)((Object)UnifiedSet.newSet()));
    }

    public <R extends Collection<Pair<K, Integer>>> R zipWithIndex(R target) {
        this.forEach(ZipWithIndexProcedure.create(target));
        return target;
    }

    public RichIterable<RichIterable<K>> chunk(int size) {
        return MutableCollectionIterate.chunk(this, size);
    }

    public MutableSet<K> union(SetIterable<? extends K> set) {
        return SetIterables.unionInto(this, set, this.newEmpty());
    }

    public <R extends Set<K>> R unionInto(SetIterable<? extends K> set, R targetSet) {
        return SetIterables.unionInto(this, set, targetSet);
    }

    public MutableSet<K> intersect(SetIterable<? extends K> set) {
        return SetIterables.intersectInto(this, set, this.newEmpty());
    }

    public <R extends Set<K>> R intersectInto(SetIterable<? extends K> set, R targetSet) {
        return SetIterables.intersectInto(this, set, targetSet);
    }

    public MutableSet<K> difference(SetIterable<? extends K> subtrahendSet) {
        return SetIterables.differenceInto(this, subtrahendSet, this.newEmpty());
    }

    public <R extends Set<K>> R differenceInto(SetIterable<? extends K> subtrahendSet, R targetSet) {
        return SetIterables.differenceInto(this, subtrahendSet, targetSet);
    }

    public MutableSet<K> symmetricDifference(SetIterable<? extends K> setB) {
        return SetIterables.symmetricDifferenceInto(this, setB, this.newEmpty());
    }

    public <R extends Set<K>> R symmetricDifferenceInto(SetIterable<? extends K> set, R targetSet) {
        return SetIterables.symmetricDifferenceInto(this, set, targetSet);
    }

    public boolean isSubsetOf(SetIterable<? extends K> candidateSuperset) {
        return SetIterables.isSubsetOf(this, candidateSuperset);
    }

    public boolean isProperSubsetOf(SetIterable<? extends K> candidateSuperset) {
        return SetIterables.isProperSubsetOf(this, candidateSuperset);
    }

    public MutableSet<UnsortedSetIterable<K>> powerSet() {
        return SetIterables.powerSet(this);
    }

    public <B> LazyIterable<Pair<K, B>> cartesianProduct(SetIterable<B> set) {
        return SetIterables.cartesianProduct(this, set);
    }

    public K get(K key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return null;
        }
        if (cur instanceof ChainedBucket) {
            return this.chainedGet(key, (ChainedBucket)cur);
        }
        if (this.nonNullTableObjectEquals(cur, key)) {
            return (K)cur;
        }
        return null;
    }

    private K chainedGet(K key, ChainedBucket bucket) {
        while (true) {
            if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                return this.nonSentinel(bucket.zero);
            }
            if (bucket.one == null) {
                return null;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                return this.nonSentinel(bucket.one);
            }
            if (bucket.two == null) {
                return null;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                return this.nonSentinel(bucket.two);
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            bucket = (ChainedBucket)bucket.three;
        }
        if (bucket.three == null) {
            return null;
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            return this.nonSentinel(bucket.three);
        }
        return null;
    }

    public K put(K key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            this.table[index] = UnifiedSetWithHashingStrategy.toSentinelIfNull(key);
            if (++this.occupied > this.maxSize) {
                this.rehash();
            }
            return key;
        }
        if (cur instanceof ChainedBucket || !this.nonNullTableObjectEquals(cur, key)) {
            return this.chainedPut(key, index);
        }
        return this.nonSentinel(cur);
    }

    private K chainedPut(K key, int index) {
        if (this.table[index] instanceof ChainedBucket) {
            ChainedBucket bucket = (ChainedBucket)this.table[index];
            while (true) {
                if (this.nonNullTableObjectEquals(bucket.zero, key)) {
                    return this.nonSentinel(bucket.zero);
                }
                if (bucket.one == null) {
                    bucket.one = UnifiedSetWithHashingStrategy.toSentinelIfNull(key);
                    if (++this.occupied > this.maxSize) {
                        this.rehash();
                    }
                    return key;
                }
                if (this.nonNullTableObjectEquals(bucket.one, key)) {
                    return this.nonSentinel(bucket.one);
                }
                if (bucket.two == null) {
                    bucket.two = UnifiedSetWithHashingStrategy.toSentinelIfNull(key);
                    if (++this.occupied > this.maxSize) {
                        this.rehash();
                    }
                    return key;
                }
                if (this.nonNullTableObjectEquals(bucket.two, key)) {
                    return this.nonSentinel(bucket.two);
                }
                if (!(bucket.three instanceof ChainedBucket)) break;
                bucket = (ChainedBucket)bucket.three;
            }
            if (bucket.three == null) {
                bucket.three = UnifiedSetWithHashingStrategy.toSentinelIfNull(key);
                if (++this.occupied > this.maxSize) {
                    this.rehash();
                }
                return key;
            }
            if (this.nonNullTableObjectEquals(bucket.three, key)) {
                return this.nonSentinel(bucket.three);
            }
            bucket.three = new ChainedBucket(bucket.three, key);
            if (++this.occupied > this.maxSize) {
                this.rehash();
            }
            return key;
        }
        ChainedBucket newBucket = new ChainedBucket(this.table[index], key);
        this.table[index] = newBucket;
        if (++this.occupied > this.maxSize) {
            this.rehash();
        }
        return key;
    }

    public K removeFromPool(K key) {
        int index = this.index(key);
        Object cur = this.table[index];
        if (cur == null) {
            return null;
        }
        if (cur instanceof ChainedBucket) {
            return this.removeFromChainForPool((ChainedBucket)cur, key, index);
        }
        if (this.nonNullTableObjectEquals(cur, key)) {
            this.table[index] = null;
            --this.occupied;
            return this.nonSentinel(cur);
        }
        return null;
    }

    private K removeFromChainForPool(ChainedBucket bucket, K key, int index) {
        if (this.nonNullTableObjectEquals(bucket.zero, key)) {
            Object result = bucket.zero;
            bucket.zero = bucket.removeLast(0);
            if (bucket.zero == null) {
                this.table[index] = null;
            }
            --this.occupied;
            return this.nonSentinel(result);
        }
        if (bucket.one == null) {
            return null;
        }
        if (this.nonNullTableObjectEquals(bucket.one, key)) {
            Object result = bucket.one;
            bucket.one = bucket.removeLast(1);
            --this.occupied;
            return this.nonSentinel(result);
        }
        if (bucket.two == null) {
            return null;
        }
        if (this.nonNullTableObjectEquals(bucket.two, key)) {
            Object result = bucket.two;
            bucket.two = bucket.removeLast(2);
            --this.occupied;
            return this.nonSentinel(result);
        }
        if (bucket.three == null) {
            return null;
        }
        if (bucket.three instanceof ChainedBucket) {
            return this.removeDeepChainForPool(bucket, key);
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            Object result = bucket.three;
            bucket.three = bucket.removeLast(3);
            --this.occupied;
            return this.nonSentinel(result);
        }
        return null;
    }

    private K removeDeepChainForPool(ChainedBucket oldBucket, K key) {
        ChainedBucket bucket;
        while (true) {
            if (this.nonNullTableObjectEquals((bucket = (ChainedBucket)oldBucket.three).zero, key)) {
                Object result = bucket.zero;
                bucket.zero = bucket.removeLast(0);
                if (bucket.zero == null) {
                    oldBucket.three = null;
                }
                --this.occupied;
                return this.nonSentinel(result);
            }
            if (bucket.one == null) {
                return null;
            }
            if (this.nonNullTableObjectEquals(bucket.one, key)) {
                Object result = bucket.one;
                bucket.one = bucket.removeLast(1);
                --this.occupied;
                return this.nonSentinel(result);
            }
            if (bucket.two == null) {
                return null;
            }
            if (this.nonNullTableObjectEquals(bucket.two, key)) {
                Object result = bucket.two;
                bucket.two = bucket.removeLast(2);
                --this.occupied;
                return this.nonSentinel(result);
            }
            if (bucket.three == null) {
                return null;
            }
            if (!(bucket.three instanceof ChainedBucket)) break;
            oldBucket = bucket;
        }
        if (this.nonNullTableObjectEquals(bucket.three, key)) {
            Object result = bucket.three;
            bucket.three = bucket.removeLast(3);
            --this.occupied;
            return this.nonSentinel(result);
        }
        return null;
    }

    private K nonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        if (key == null) {
            return NULL_KEY;
        }
        return key;
    }

    private boolean nonNullTableObjectEquals(Object cur, K key) {
        return cur == key || (cur == NULL_KEY ? key == null : this.hashingStrategy.equals(this.nonSentinel(cur), key));
    }

    public <K2, V> MutableMap<K2, V> aggregateInPlaceBy(final Function<? super K, ? extends K2> groupBy, final Function0<? extends V> zeroValueFactory, final Procedure2<? super V, ? super K> mutatingAggregator) {
        final UnifiedMap map = UnifiedMap.newMap();
        this.forEach((Procedure<? super K>)new Procedure<K>(){

            public void value(K each) {
                Object key = groupBy.valueOf(each);
                Object value = map.getIfAbsentPut(key, zeroValueFactory);
                mutatingAggregator.value(value, each);
            }
        });
        return map;
    }

    public <K2, V> MutableMap<K2, V> aggregateBy(final Function<? super K, ? extends K2> groupBy, final Function0<? extends V> zeroValueFactory, final Function2<? super V, ? super K, ? extends V> nonMutatingAggregator) {
        final UnifiedMap map = UnifiedMap.newMap();
        this.forEach((Procedure<? super K>)new Procedure<K>(){

            public void value(K each) {
                Object key = groupBy.valueOf(each);
                Object value = map.getIfAbsentPut(key, zeroValueFactory);
                map.put(key, nonMutatingAggregator.value(value, each));
            }
        });
        return map;
    }

    private static final class ChainedBucket {
        private Object zero;
        private Object one;
        private Object two;
        private Object three;

        private ChainedBucket() {
        }

        private ChainedBucket(Object first, Object second) {
            this.zero = first;
            this.one = second;
        }

        public void remove(int i) {
            if (i <= 3) {
                switch (i) {
                    case 0: {
                        this.zero = this.removeLast(0);
                        return;
                    }
                    case 1: {
                        this.one = this.removeLast(1);
                        return;
                    }
                    case 2: {
                        this.two = this.removeLast(2);
                        return;
                    }
                    case 3: {
                        if (this.three instanceof ChainedBucket) {
                            this.removeLongChain(this, i - 3);
                            return;
                        }
                        this.three = null;
                        return;
                    }
                }
                throw new AssertionError();
            }
            this.removeLongChain(this, i - 3);
        }

        private void removeLongChain(ChainedBucket oldBucket, int i) {
            block6: while (true) {
                ChainedBucket bucket = (ChainedBucket)oldBucket.three;
                switch (i) {
                    case 0: {
                        bucket.zero = bucket.removeLast(0);
                        return;
                    }
                    case 1: {
                        bucket.one = bucket.removeLast(1);
                        return;
                    }
                    case 2: {
                        bucket.two = bucket.removeLast(2);
                        return;
                    }
                    case 3: {
                        if (bucket.three instanceof ChainedBucket) {
                            i -= 3;
                            oldBucket = bucket;
                            continue block6;
                        }
                        bucket.three = null;
                        return;
                    }
                }
                break;
            }
            throw new AssertionError();
        }

        public Object get(int i) {
            ChainedBucket bucket = this;
            while (i > 3 && bucket.three instanceof ChainedBucket) {
                bucket = (ChainedBucket)bucket.three;
                i -= 3;
            }
            block8: while (true) {
                switch (i) {
                    case 0: {
                        return bucket.zero;
                    }
                    case 1: {
                        return bucket.one;
                    }
                    case 2: {
                        return bucket.two;
                    }
                    case 3: {
                        if (bucket.three instanceof ChainedBucket) {
                            i -= 3;
                            bucket = (ChainedBucket)bucket.three;
                            continue block8;
                        }
                        return bucket.three;
                    }
                    case 4: {
                        return null;
                    }
                }
                break;
            }
            throw new AssertionError();
        }

        public Object removeLast(int cur) {
            if (this.three instanceof ChainedBucket) {
                return this.removeLast(this);
            }
            if (this.three != null) {
                Object result = this.three;
                this.three = null;
                return cur == 3 ? null : result;
            }
            if (this.two != null) {
                Object result = this.two;
                this.two = null;
                return cur == 2 ? null : result;
            }
            if (this.one != null) {
                Object result = this.one;
                this.one = null;
                return cur == 1 ? null : result;
            }
            this.zero = null;
            return null;
        }

        private Object removeLast(ChainedBucket oldBucket) {
            ChainedBucket bucket;
            while (true) {
                bucket = (ChainedBucket)oldBucket.three;
                if (!(bucket.three instanceof ChainedBucket)) break;
                oldBucket = bucket;
            }
            if (bucket.three != null) {
                Object result = bucket.three;
                bucket.three = null;
                return result;
            }
            if (bucket.two != null) {
                Object result = bucket.two;
                bucket.two = null;
                return result;
            }
            if (bucket.one != null) {
                Object result = bucket.one;
                bucket.one = null;
                return result;
            }
            Object result = bucket.zero;
            oldBucket.three = null;
            return result;
        }

        public ChainedBucket copy() {
            ChainedBucket result;
            ChainedBucket dest = result = new ChainedBucket();
            ChainedBucket src = this;
            while (true) {
                dest.zero = src.zero;
                dest.one = src.one;
                dest.two = src.two;
                if (!(src.three instanceof ChainedBucket)) break;
                dest.three = new ChainedBucket();
                src = (ChainedBucket)src.three;
                dest = (ChainedBucket)dest.three;
            }
            dest.three = src.three;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PositionalIterator
    implements Iterator<K> {
        protected int count;
        protected int position;
        protected int chainPosition;
        protected boolean lastReturned;

        protected PositionalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < UnifiedSetWithHashingStrategy.this.size();
        }

        @Override
        public void remove() {
            if (!this.lastReturned) {
                throw new IllegalStateException("next() must be called as many times as remove()");
            }
            --this.count;
            --UnifiedSetWithHashingStrategy.this.occupied;
            if (this.chainPosition != 0) {
                this.removeFromChain();
                return;
            }
            int pos = this.position - 1;
            Object key = UnifiedSetWithHashingStrategy.this.table[pos];
            if (key instanceof ChainedBucket) {
                this.removeLastFromChain((ChainedBucket)key, pos);
                return;
            }
            UnifiedSetWithHashingStrategy.this.table[pos] = null;
            this.position = pos;
            this.lastReturned = false;
        }

        protected void removeFromChain() {
            ChainedBucket chain = (ChainedBucket)UnifiedSetWithHashingStrategy.this.table[this.position];
            chain.remove(--this.chainPosition);
            this.lastReturned = false;
        }

        protected void removeLastFromChain(ChainedBucket bucket, int tableIndex) {
            bucket.removeLast(0);
            if (bucket.zero == null) {
                UnifiedSetWithHashingStrategy.this.table[tableIndex] = null;
            }
            this.lastReturned = false;
        }

        protected K nextFromChain() {
            ChainedBucket bucket = (ChainedBucket)UnifiedSetWithHashingStrategy.this.table[this.position];
            Object cur = bucket.get(this.chainPosition);
            ++this.chainPosition;
            if (bucket.get(this.chainPosition) == null) {
                this.chainPosition = 0;
                ++this.position;
            }
            this.lastReturned = true;
            return UnifiedSetWithHashingStrategy.this.nonSentinel(cur);
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            Object[] table = UnifiedSetWithHashingStrategy.this.table;
            if (this.chainPosition != 0) {
                return this.nextFromChain();
            }
            while (table[this.position] == null) {
                ++this.position;
            }
            Object cur = table[this.position];
            if (cur instanceof ChainedBucket) {
                return this.nextFromChain();
            }
            ++this.position;
            this.lastReturned = true;
            return UnifiedSetWithHashingStrategy.this.nonSentinel(cur);
        }
    }
}

