/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableIntStack;
import com.gs.collections.api.stack.primitive.MutableIntStack;
import com.gs.collections.impl.factory.primitive.IntStacks;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedIntStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableIntStack
implements MutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntStack stack;

    UnmodifiableIntStack(MutableIntStack stack) {
        this.stack = stack;
    }

    public void push(int item) {
        throw new UnsupportedOperationException("Cannot push on an UnmodifiableIntStack");
    }

    public int pop() {
        throw new UnsupportedOperationException("Cannot pop from an UnmodifiableIntStack");
    }

    public IntList pop(int count) {
        throw new UnsupportedOperationException("Cannot pop from an UnmodifiableIntStack");
    }

    public int peek() {
        return this.stack.peek();
    }

    public IntList peek(int count) {
        return this.stack.peek(count);
    }

    public int peekAt(int index) {
        return this.stack.peekAt(index);
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot clear an UnmodifiableIntStack");
    }

    public boolean contains(int value) {
        return this.stack.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.stack.containsAll(source);
    }

    public IntIterator intIterator() {
        return this.stack.intIterator();
    }

    public void forEach(IntProcedure procedure) {
        this.stack.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableIntStack select(IntPredicate predicate) {
        return this.stack.select(predicate);
    }

    public MutableIntStack reject(IntPredicate predicate) {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    public long sum() {
        return this.stack.sum();
    }

    public int max() {
        return this.stack.max();
    }

    public int min() {
        return this.stack.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    public int maxIfEmpty(int defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.stack.average();
    }

    public double median() {
        return this.stack.median();
    }

    public MutableIntList toSortedList() {
        return this.stack.toSortedList();
    }

    public int[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    public int[] toArray() {
        return this.stack.toArray();
    }

    public String toString() {
        return this.stack.toString();
    }

    public String makeString() {
        return this.stack.makeString();
    }

    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableIntList toList() {
        return this.stack.toList();
    }

    public MutableIntSet toSet() {
        return this.stack.toSet();
    }

    public MutableIntBag toBag() {
        return this.stack.toBag();
    }

    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    public int hashCode() {
        return this.stack.hashCode();
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public MutableIntStack asUnmodifiable() {
        return this;
    }

    public MutableIntStack asSynchronized() {
        return new SynchronizedIntStack(this);
    }

    public ImmutableIntStack toImmutable() {
        return IntStacks.immutable.withAllReversed((IntIterable)this);
    }
}

