/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableFloatBag;
import com.gs.collections.api.bag.primitive.FloatBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.primitive.FloatBags;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableFloatEmptyBag is an optimization for {@link ImmutableFloatBag} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyBag.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableFloatEmptyBag implements ImmutableFloatBag, Serializable
{
    private static final long serialVersionUID = 1L;

    static final ImmutableFloatBag INSTANCE = new ImmutableFloatEmptyBag();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public ImmutableFloatBag newWith(float element)
    {
        return new ImmutableFloatSingletonBag(element);
    }

    public ImmutableFloatBag newWithout(float element)
    {
        return this;
    }

    public ImmutableFloatBag newWithAll(FloatIterable elements)
    {
        return FloatBags.immutable.withAll(elements);
    }

    public ImmutableFloatBag newWithoutAll(FloatIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public boolean contains(float value)
    {
        return false;
    }

    public boolean containsAll(FloatIterable source)
    {
        return source.isEmpty();
    }

    public boolean containsAll(float... elements)
    {
        return elements.length == 0;
    }

    public void forEach(FloatProcedure procedure)
    {
    }

    public ImmutableFloatBag select(FloatPredicate predicate)
    {
        return this;
    }

    public ImmutableFloatBag reject(FloatPredicate predicate)
    {
        return this;
    }

    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return Bags.immutable.of();
    }

    public MutableFloatList toList()
    {
        return new FloatArrayList();
    }

    public int sizeDistinct()
    {
        return 0;
    }

    public int occurrencesOf(float item)
    {
        return 0;
    }

    public void forEachWithOccurrences(FloatIntProcedure floatIntProcedure)
    {
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return ifNone;
    }

    public int count(FloatPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return false;
    }

    public double sum()
    {
        return 0.0;
    }

    public float min()
    {
        throw new NoSuchElementException();
    }

    public float max()
    {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public float minIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public float[] toSortedArray()
    {
        return new float[0];
    }

    public MutableFloatList toSortedList()
    {
        return new FloatArrayList();
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof FloatBag))
        {
            return false;
        }
        FloatBag bag = (FloatBag) obj;
        return bag.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    public MutableFloatSet toSet()
    {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag()
    {
        return new FloatHashBag();
    }

    public ImmutableFloatBag toImmutable()
    {
        return this;
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public float[] toArray()
    {
        return new float[0];
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator()
    {
        return new InternalFloatIterator();
    }

    private static class InternalFloatIterator implements FloatIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public float next()
        {
            throw new NoSuchElementException();
        }
    }
}
