/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableLongBag;
import com.gs.collections.api.bag.primitive.LongBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.primitive.LongBags;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableLongSingletonBag is an optimization for {@link ImmutableLongBag} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonBag.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableLongSingletonBag implements ImmutableLongBag, Serializable
{
    private static final long serialVersionUID = 1L;

    private final long element1;

    ImmutableLongSingletonBag (long element)
    {
        this.element1 = element;
    }

    public ImmutableLongBag newWith(long element)
    {
        return LongBags.immutable.with(this.element1, element);
    }

    public ImmutableLongBag newWithout(long element)
    {
        return this.element1 == element ? LongBags.immutable.with() : this;
    }

    public ImmutableLongBag newWithAll(LongIterable elements)
    {
        return LongHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableLongBag newWithoutAll(LongIterable elements)
    {
        return elements.contains(this.element1) ? LongBags.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public boolean contains(long value)
    {
        return this.element1 == value;
    }

    public boolean containsAll(LongIterable source)
    {
        for (LongIterator iterator = source.longIterator(); iterator.hasNext(); )
        {
            if (this.element1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(long... source)
    {
        for (long value : source)
        {
            if (this.element1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public void forEach(LongProcedure procedure)
    {
        procedure.value(this.element1);
    }

    public ImmutableLongBag select(LongPredicate predicate)
    {
        return predicate.accept(this.element1) ? LongHashBag.newBagWith(this.element1).toImmutable()
                : new LongHashBag().toImmutable();
    }

    public ImmutableLongBag reject(LongPredicate predicate)
    {
        return predicate.accept(this.element1) ? new LongHashBag().toImmutable()
                : LongHashBag.newBagWith(this.element1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function)
    {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    public MutableLongList toList()
    {
        return LongArrayList.newListWith(this.element1);
    }

    public int sizeDistinct()
    {
        return 1;
    }

    public int occurrencesOf(long item)
    {
        return this.element1 == item ? 1 : 0;
    }

    public void forEachWithOccurrences(LongIntProcedure longIntProcedure)
    {
        longIntProcedure.value(this.element1, 1);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(LongPredicate predicate)
    {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public long sum()
    {
        return this.element1;
    }

    public long min()
    {
        return this.element1;
    }

    public long max()
    {
        return this.element1;
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.element1;
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.element1;
    }

    public double average()
    {
        return this.element1;
    }

    public double median()
    {
        return this.element1;
    }

    public long[] toSortedArray()
    {
        return new long[]{this.element1};
    }

    public MutableLongList toSortedList()
    {
        return LongArrayList.newListWith(this.element1);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof LongBag))
        {
            return false;
        }
        LongBag bag = (LongBag) obj;
        if (bag.size() != 1)
        {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode()
    {
        return (int) (this.element1 ^ this.element1 >>> 32) ^ 1;
    }

    public MutableLongSet toSet()
    {
        return LongHashSet.newSetWith(this.element1);
    }

    public MutableLongBag toBag()
    {
        return LongHashBag.newBagWith(this.element1);
    }

    public ImmutableLongBag toImmutable()
    {
        return this;
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public long[] toArray()
    {
        return new long[]{this.element1};
    }

    @Override
    public String toString()
    {
        return '[' + this.makeString() + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public LongIterator longIterator()
    {
        return LongHashBag.newBagWith(this.element1).longIterator();
    }
}

