/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableIntBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableIntCollection;
import com.gs.collections.impl.factory.primitive.IntBags;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveBag.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableIntBag
        extends AbstractUnmodifiableIntCollection
        implements MutableIntBag
{
    private static final long serialVersionUID = 1L;

    UnmodifiableIntBag(MutableIntBag bag)
    {
        super(bag);
    }

    private MutableIntBag getMutableIntBag()
    {
        return (MutableIntBag) this.getIntCollection();
    }

    @Override
    public UnmodifiableIntBag with(int element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntBag without(int element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntBag withAll(IntIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntBag withoutAll(IntIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public void addOccurrences(int item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call addOccurrences() on " + this.getClass().getSimpleName());
    }

    public boolean removeOccurrences(int item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call removeOccurrences() on " + this.getClass().getSimpleName());
    }

    public int sizeDistinct()
    {
        return this.getMutableIntBag().sizeDistinct();
    }

    public int occurrencesOf(int item)
    {
        return this.getMutableIntBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(IntIntProcedure procedure)
    {
        this.getMutableIntBag().forEachWithOccurrences(procedure);
    }

    @Override
    public MutableIntBag select(IntPredicate predicate)
    {
        return this.getMutableIntBag().select(predicate);
    }

    @Override
    public MutableIntBag reject(IntPredicate predicate)
    {
        return this.getMutableIntBag().reject(predicate);
    }

    @Override
    public <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function)
    {
        return this.getMutableIntBag().collect(function);
    }

    @Override
    public boolean equals(Object otherBag)
    {
        return this.getMutableIntBag().equals(otherBag);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableIntBag().hashCode();
    }

    @Override
    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public MutableIntBag asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableIntBag asSynchronized()
    {
        return new SynchronizedIntBag(this);
    }

    @Override
    public ImmutableIntBag toImmutable()
    {
        return IntBags.immutable.withAll(this);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableIntBag().injectInto(injectedValue, function);
    }
}
