/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableByteFloatMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteFloatMap;
import com.gs.collections.api.map.primitive.ByteFloatMap;

/**
 * ImmutableByteFloatMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteFloatMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteFloatMapFactoryImpl implements ImmutableByteFloatMapFactory
{
    public ImmutableByteFloatMap of()
    {
        return this.with();
    }

    public ImmutableByteFloatMap with()
    {
        return ImmutableByteFloatEmptyMap.INSTANCE;
    }

    public ImmutableByteFloatMap of(byte key, float value)
    {
        return this.with(key, value);
    }

    public ImmutableByteFloatMap with(byte key, float value)
    {
        return new ImmutableByteFloatSingletonMap(key, value);
    }

    public ImmutableByteFloatMap ofAll(ByteFloatMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteFloatMap withAll(ByteFloatMap map)
    {
        if (map instanceof ImmutableByteFloatMap)
        {
            return (ImmutableByteFloatMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableByteFloatHashMap(map);
    }
}
