/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableDoubleDoubleMapFactory;
import com.gs.collections.api.map.primitive.ImmutableDoubleDoubleMap;
import com.gs.collections.api.map.primitive.DoubleDoubleMap;

/**
 * ImmutableDoubleDoubleMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleDoubleMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleDoubleMapFactoryImpl implements ImmutableDoubleDoubleMapFactory
{
    public ImmutableDoubleDoubleMap of()
    {
        return this.with();
    }

    public ImmutableDoubleDoubleMap with()
    {
        return ImmutableDoubleDoubleEmptyMap.INSTANCE;
    }

    public ImmutableDoubleDoubleMap of(double key, double value)
    {
        return this.with(key, value);
    }

    public ImmutableDoubleDoubleMap with(double key, double value)
    {
        return new ImmutableDoubleDoubleSingletonMap(key, value);
    }

    public ImmutableDoubleDoubleMap ofAll(DoubleDoubleMap map)
    {
        return this.withAll(map);
    }

    public ImmutableDoubleDoubleMap withAll(DoubleDoubleMap map)
    {
        if (map instanceof ImmutableDoubleDoubleMap)
        {
            return (ImmutableDoubleDoubleMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleDoubleHashMap(map);
    }
}
