/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableFloatDoubleMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatDoubleMap;
import com.gs.collections.api.map.primitive.FloatDoubleMap;

/**
 * ImmutableFloatDoubleMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatDoubleMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatDoubleMapFactoryImpl implements ImmutableFloatDoubleMapFactory
{
    public ImmutableFloatDoubleMap of()
    {
        return this.with();
    }

    public ImmutableFloatDoubleMap with()
    {
        return ImmutableFloatDoubleEmptyMap.INSTANCE;
    }

    public ImmutableFloatDoubleMap of(float key, double value)
    {
        return this.with(key, value);
    }

    public ImmutableFloatDoubleMap with(float key, double value)
    {
        return new ImmutableFloatDoubleSingletonMap(key, value);
    }

    public ImmutableFloatDoubleMap ofAll(FloatDoubleMap map)
    {
        return this.withAll(map);
    }

    public ImmutableFloatDoubleMap withAll(FloatDoubleMap map)
    {
        if (map instanceof ImmutableFloatDoubleMap)
        {
            return (ImmutableFloatDoubleMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatDoubleHashMap(map);
    }
}
