/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntIntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.IntIntMap;
import com.gs.collections.api.map.primitive.ImmutableIntIntMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.IntIntPair;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.IntIntMaps;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.IntIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;

/**
 * ImmutableIntIntSingletonMap is an optimization for {@link ImmutableIntIntMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableIntIntSingletonMap implements ImmutableIntIntMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    private final int key1;
    private final int value1;

    ImmutableIntIntSingletonMap(int key1, int value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public int get(int key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public int getIfAbsent(int key, int ifAbsent)
    {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public int getOrThrow(int key)
    {
        if (this.key1 == key)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key)
    {
        return this.key1 == key;
    }

    public boolean containsValue(int value)
    {
        return this.value1 == value;
    }

    public void forEachValue(IntProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(IntProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(IntIntProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyIntIterable keysView()
    {
        return IntLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<IntIntPair> keyValuesView()
    {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableIntIntMap select(IntIntPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? IntIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new IntIntHashMap().toImmutable();
    }

    public ImmutableIntIntMap reject(IntIntPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new IntIntHashMap().toImmutable()
                : IntIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public ImmutableIntIntMap toImmutable()
    {
        return this;
    }

    public IntIterator intIterator()
    {
        return IntIntHashMap.newWithKeysValues(this.key1, this.value1).intIterator();
    }

    public void forEach(IntProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(IntPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum()
    {
        return this.value1;
    }

    public int min()
    {
        return this.value1;
    }

    public int max()
    {
        return this.value1;
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.value1;
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public int[] toSortedArray()
    {
        return new int[]{this.value1};
    }

    public MutableIntList toSortedList()
    {
        return IntArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableIntCollection select(IntPredicate predicate)
    {
        return predicate.accept(this.value1) ? IntArrayList.newListWith(this.value1).toImmutable() : new IntArrayList().toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate)
    {
        return predicate.accept(this.value1) ? new IntArrayList().toImmutable() : IntArrayList.newListWith(this.value1).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public int[] toArray()
    {
        return new int[]{this.value1};
    }

    public boolean contains(int value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(int... source)
    {
        for (int value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(IntIterable source)
    {
        for (IntIterator iterator = source.intIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableIntList toList()
    {
        return IntArrayList.newListWith(this.value1);
    }

    public MutableIntSet toSet()
    {
        return IntHashSet.newSetWith(this.value1);
    }

    public MutableIntBag toBag()
    {
        return IntHashBag.newBagWith(this.value1);
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public ImmutableIntIntMap newWithKeyValue(int key, int value)
    {
        return IntIntMaps.immutable.withAll(IntIntHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableIntIntMap newWithoutKey(int key)
    {
        return this.key1 == key ? IntIntMaps.immutable.with() : this;
    }

    public ImmutableIntIntMap newWithoutAllKeys(IntIterable keys)
    {
        return keys.contains(this.key1) ? IntIntMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(IntHashSet.newSetWith(this.key1));
    }

    public MutableIntCollection values()
    {
        return UnmodifiableIntCollection.of(IntArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof IntIntMap))
        {
            return false;
        }
        IntIntMap map = (IntIntMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return this.key1 ^ this.value1;
    }

    @Override
    public String toString()
    {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
