/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.IntLongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.IntLongProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.IntLongMap;
import com.gs.collections.api.map.primitive.ImmutableIntLongMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.IntLongPair;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyIntIterate;

/**
 * ImmutableIntLongEmptyMap is an optimization for {@link ImmutableIntLongMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableIntLongEmptyMap implements ImmutableIntLongMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    static final ImmutableIntLongMap INSTANCE = new ImmutableIntLongEmptyMap();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public long get(int key)
    {
        return EMPTY_VALUE;
    }

    public long getIfAbsent(int key, long ifAbsent)
    {
        return ifAbsent;
    }

    public long getOrThrow(int key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key)
    {
        return false;
    }

    public boolean containsValue(long value)
    {
        return false;
    }

    public void forEachValue(LongProcedure procedure)
    {
    }

    public void forEachKey(IntProcedure procedure)
    {
    }

    public void forEachKeyValue(IntLongProcedure procedure)
    {
    }

    public LazyIntIterable keysView()
    {
        return LazyIntIterate.empty();
    }

    public RichIterable<IntLongPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableIntLongMap select(IntLongPredicate predicate)
    {
        return this;
    }

    public ImmutableIntLongMap reject(IntLongPredicate predicate)
    {
        return this;
    }

    public ImmutableIntLongMap toImmutable()
    {
        return this;
    }

    public LongIterator longIterator()
    {
        return new InternalLongIterator();
    }

    private static class InternalLongIterator implements LongIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public long next()
        {
            throw new NoSuchElementException();
        }
    }

    public void forEach(LongProcedure procedure)
    {
    }

    public int count(LongPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public long min()
    {
        throw new NoSuchElementException();
    }

    public long max()
    {
        throw new NoSuchElementException();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return defaultValue;
    }

    public long minIfEmpty(long defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public long[] toSortedArray()
    {
        return new long[0];
    }

    public MutableLongList toSortedList()
    {
        return new LongArrayList();
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return true;
    }

    public ImmutableLongCollection select(LongPredicate predicate)
    {
        return LongLists.immutable.with();
    }

    public ImmutableLongCollection reject(LongPredicate predicate)
    {
        return LongLists.immutable.with();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public long[] toArray()
    {
        return new long[0];
    }

    public boolean contains(long value)
    {
        return false;
    }

    public boolean containsAll(long... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(LongIterable source)
    {
        return source.isEmpty();
    }

    public MutableLongList toList()
    {
        return new LongArrayList();
    }

    public MutableLongSet toSet()
    {
        return new LongHashSet();
    }

    public MutableLongBag toBag()
    {
        return new LongHashBag();
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public ImmutableIntLongMap newWithKeyValue(int key, long value)
    {
        return new ImmutableIntLongSingletonMap(key, value);
    }

    public ImmutableIntLongMap newWithoutKey(int key)
    {
        return this;
    }

    public ImmutableIntLongMap newWithoutAllKeys(IntIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(new IntHashSet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(new LongArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof IntLongMap))
        {
            return false;
        }
        IntLongMap map = (IntLongMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
