/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectBytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectByteProcedure;
import com.gs.collections.api.map.primitive.ObjectByteMap;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableObjectByteMap;
import com.gs.collections.api.map.primitive.MutableObjectByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.ObjectBytePair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.map.mutable.primitive.ObjectByteHashMap;
import com.gs.collections.impl.set.mutable.UnmodifiableMutableSet;

/**
 * ImmutableObjectByteHashMap is the non-modifiable equivalent of {@link ObjectByteHashMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectByteHashMap<K> extends AbstractImmutableObjectByteMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectByteMap<K> delegate;

    ImmutableObjectByteHashMap(ObjectByteMap<? extends K> delegate)
    {
        this.delegate = new ObjectByteHashMap<K>(delegate);
    }

    public ByteIterator byteIterator()
    {
        return this.delegate.byteIterator();
    }

    public void forEach(ByteProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableByteCollection select(BytePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteCollection reject(BytePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return ((ObjectByteHashMap<T>) this.delegate).injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public byte max()
    {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte min()
    {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public byte[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }


    public MutableByteList toSortedList()
    {
        return this.delegate.toSortedList();
    }


    public byte[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(byte value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.delegate.toList();
    }

    public MutableByteSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableObjectByteMap<K> newWithKeyValue(K key, byte value)
    {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectByteMap<K> newWithoutKey(K key)
    {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectByteMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectByteHashMap<K> map = ObjectByteHashMap.newMap();
        map.putAll(this);
        Iterator<? extends K> iterator = keys.iterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public byte get(Object key)
    {
        return this.delegate.get(key);
    }

    public byte getOrThrow(Object key)
    {
        return this.delegate.getOrThrow(key);
    }

    public byte getIfAbsent(Object key, byte ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(byte value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectByteProcedure<? super K> objectByteProcedure)
    {
        this.delegate.forEachKeyValue(objectByteProcedure);
    }

    public ImmutableObjectByteMap<K> select(ObjectBytePredicate<? super K> objectBytePredicate)
    {
        return this.delegate.select(objectBytePredicate).toImmutable();
    }

    public ImmutableObjectByteMap<K> reject(ObjectBytePredicate<? super K> objectBytePredicate)
    {
        return this.delegate.reject(objectBytePredicate).toImmutable();
    }

    public ImmutableObjectByteMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet()
    {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    public LazyIterable<K> keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ObjectBytePair<K>> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace()
    {
        return new ImmutableObjectByteMapSerializationProxy<K>(this);
    }
}
