/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.factory.map.primitive.ImmutableObjectDoubleMapFactory;
import com.gs.collections.api.map.primitive.ImmutableObjectDoubleMap;
import com.gs.collections.api.map.primitive.ObjectDoubleMap;

/**
 * ImmutableObjectDoubleMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableObjectDoubleMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableObjectDoubleMapFactoryImpl implements ImmutableObjectDoubleMapFactory
{
    public <K> ImmutableObjectDoubleMap<K> of()
    {
        return this.with();
    }

    public <K> ImmutableObjectDoubleMap<K> with()
    {
        return (ImmutableObjectDoubleMap<K>) ImmutableObjectDoubleEmptyMap.INSTANCE;
    }

    public <K> ImmutableObjectDoubleMap<K> of(K key, double value)
    {
        return this.with(key, value);
    }

    public <K> ImmutableObjectDoubleMap<K> with(K key, double value)
    {
        return new ImmutableObjectDoubleSingletonMap<K>(key, value);
    }

    public <K> ImmutableObjectDoubleMap<K> ofAll(ObjectDoubleMap<? extends K> map)
    {
        return this.withAll(map);
    }

    public <K> ImmutableObjectDoubleMap<K> withAll(ObjectDoubleMap<? extends K> map)
    {
        if (map instanceof ImmutableObjectDoubleMap)
        {
            return (ImmutableObjectDoubleMap<K>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final Object[] array = new Object[1];
            map.forEachKey(new Procedure<K>()
            {
                public void value(K each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableObjectDoubleSingletonMap<K>((K) array[0], map.get(array[0]));
        }
        return new ImmutableObjectDoubleHashMap<K>(map);
    }
}
