/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedDoubleProcedure;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;

/**
 * This file was automatically generated from template file immutablePrimitiveSetSerializationProxy.stg.
 *
 * @since 4.0.
 */
public final class ImmutableDoubleSetSerializationProxy implements Externalizable
{
    private static final long serialVersionUID = 1L;

    private DoubleSet set;

    @SuppressWarnings("UnusedDeclaration")
    public ImmutableDoubleSetSerializationProxy()
    {
        // Empty constructor for Externalizable class
    }

    public ImmutableDoubleSetSerializationProxy(DoubleSet set)
    {
        this.set = set;
    }

    public void writeExternal(final ObjectOutput out) throws IOException
    {
        out.writeInt(this.set.size());
        try
        {
            this.set.forEach(new CheckedDoubleProcedure()
            {
                @Override
                public void safeValue(double item) throws Exception
                {
                    out.writeDouble(item);
                }
            });
        }
        catch (RuntimeException e)
        {
            if (e.getCause() instanceof IOException)
            {
                throw (IOException) e.getCause();
            }
            throw e;
        }
    }

    public void readExternal(ObjectInput in) throws IOException
    {
        int size = in.readInt();
        MutableDoubleSet deserializedSet = new DoubleHashSet(size);

        for (int i = 0; i < size; i++)
        {
            deserializedSet.add(in.readDouble());
        }

        this.set = deserializedSet;
    }

    private Object readResolve()
    {
        return this.set.toImmutable();
    }
}