/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableLongSetFactory;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;

/**
 * ImmutableLongSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongSetFactoryImpl implements ImmutableLongSetFactory
{
    public ImmutableLongSet of()
    {
        return this.with();
    }

    public ImmutableLongSet with()
    {
        return ImmutableLongEmptySet.INSTANCE;
    }

    public ImmutableLongSet of(long one)
    {
        return this.with(one);
    }

    public ImmutableLongSet with(long one)
    {
        return new ImmutableLongSingletonSet(one);
    }

    public ImmutableLongSet of(long... items)
    {
        return this.with(items);
    }

    public ImmutableLongSet with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return LongHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableLongSet ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableLongSet withAll(LongIterable items)
    {
        if (items instanceof ImmutableLongSet)
        {
            return (ImmutableLongSet) items;
        }
        return this.with(items.toArray());
    }
}
