/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableShortBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.bag.primitive.ShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableShortSingletonBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.primitive.ShortBags;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableShortEmptyBag
implements ImmutableShortBag,
Serializable {
    private static final long serialVersionUID = 1L;
    static final ImmutableShortBag INSTANCE = new ImmutableShortEmptyBag();

    ImmutableShortEmptyBag() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableShortBag newWith(short element) {
        return new ImmutableShortSingletonBag(element);
    }

    public ImmutableShortBag newWithout(short element) {
        return this;
    }

    public ImmutableShortBag newWithAll(ShortIterable elements) {
        return ShortBags.immutable.withAll(elements);
    }

    public ImmutableShortBag newWithoutAll(ShortIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(short value) {
        return false;
    }

    public boolean containsAll(ShortIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(short ... elements) {
        return elements.length == 0;
    }

    public void forEach(ShortProcedure procedure) {
    }

    public ImmutableShortBag select(ShortPredicate predicate) {
        return this;
    }

    public ImmutableShortBag reject(ShortPredicate predicate) {
        return this;
    }

    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        return Bags.immutable.of();
    }

    public MutableShortList toList() {
        return new ShortArrayList();
    }

    public int sizeDistinct() {
        return 0;
    }

    public int occurrencesOf(short item) {
        return 0;
    }

    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure) {
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return ifNone;
    }

    public int count(ShortPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return false;
    }

    public long sum() {
        return 0L;
    }

    public short min() {
        throw new NoSuchElementException();
    }

    public short max() {
        throw new NoSuchElementException();
    }

    public short maxIfEmpty(short defaultValue) {
        return defaultValue;
    }

    public short minIfEmpty(short defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public short[] toSortedArray() {
        return new short[0];
    }

    public MutableShortList toSortedList() {
        return new ShortArrayList();
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortBag)) {
            return false;
        }
        ShortBag bag = (ShortBag)obj;
        return bag.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableShortSet toSet() {
        return new ShortHashSet();
    }

    public MutableShortBag toBag() {
        return new ShortHashBag();
    }

    public ImmutableShortBag toImmutable() {
        return this;
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public short[] toArray() {
        return new short[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    private static class InternalShortIterator
    implements ShortIterator {
        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public short next() {
            throw new NoSuchElementException();
        }
    }
}

