/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.ParallelIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.factory.Procedures;
import com.gs.collections.impl.block.procedure.AtomicCountProcedure;
import com.gs.collections.impl.block.procedure.CollectionAddProcedure;
import com.gs.collections.impl.block.procedure.MapCollectProcedure;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.lazy.parallel.Batch;
import com.gs.collections.impl.lazy.parallel.RootBatch;
import com.gs.collections.impl.list.mutable.CompositeFastList;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractParallelIterable<T, B extends Batch<T>>
implements ParallelIterable<T> {
    protected static <T> void forEach(final AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Procedure<? super T> procedure) {
        LazyIterable futures = parallelIterable.split().collect(new Function<RootBatch<T>, Future<?>>(){

            public Future<?> valueOf(final RootBatch<T> chunk) {
                return parallelIterable.getExecutorService().submit(new Runnable(){

                    public void run() {
                        chunk.forEach(procedure);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static <T> boolean anySatisfy(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        final ExecutorCompletionService completionService = new ExecutorCompletionService(parallelIterable.getExecutorService());
        MutableSet futures = (MutableSet)parallelIterable.split().collect(new Function<RootBatch<T>, Future<Boolean>>(){

            public Future<Boolean> valueOf(final RootBatch<T> batch) {
                return completionService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return batch.anySatisfy(predicate);
                    }
                });
            }
        }, UnifiedSet.newSet());
        while (futures.notEmpty()) {
            try {
                Future future = completionService.take();
                if (((Boolean)future.get()).booleanValue()) {
                    for (Future eachFuture : futures) {
                        eachFuture.cancel(true);
                    }
                    return true;
                }
                futures.remove(future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    protected static <T> boolean allSatisfy(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        final ExecutorCompletionService completionService = new ExecutorCompletionService(parallelIterable.getExecutorService());
        MutableSet futures = (MutableSet)parallelIterable.split().collect(new Function<RootBatch<T>, Future<Boolean>>(){

            public Future<Boolean> valueOf(final RootBatch<T> batch) {
                return completionService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return batch.allSatisfy(predicate);
                    }
                });
            }
        }, UnifiedSet.newSet());
        while (futures.notEmpty()) {
            try {
                Future future = completionService.take();
                if (!((Boolean)future.get()).booleanValue()) {
                    for (Future eachFuture : futures) {
                        eachFuture.cancel(true);
                    }
                    return false;
                }
                futures.remove(future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    protected static <T> T detect(final AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        LazyIterable<? extends RootBatch<T>> chunks = parallelIterable.split();
        LazyIterable futures = chunks.collect(new Function<RootBatch<T>, Future<T>>(){

            public Future<T> valueOf(final RootBatch<T> chunk) {
                return parallelIterable.getExecutorService().submit(new Callable<T>(){

                    @Override
                    public T call() {
                        return chunk.detect(predicate);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                Object eachResult = future.get();
                if (eachResult == null) continue;
                for (Future eachFutureToCancel : futuresList) {
                    eachFutureToCancel.cancel(true);
                }
                return (T)eachResult;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public abstract ExecutorService getExecutorService();

    public abstract LazyIterable<B> split();

    protected abstract boolean isOrdered();

    protected <S, V> void collectCombine(Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        if (this.isOrdered()) {
            this.collectCombineOrdered(function, combineProcedure, state);
        } else {
            this.collectCombineUnordered(function, combineProcedure, state);
        }
    }

    private <S, V> void collectCombineOrdered(final Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<V>>(){

            public Future<V> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<V>(){

                    @Override
                    public V call() {
                        return function.valueOf((Object)chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                combineProcedure.value(state, future.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <S, V> void collectCombineUnordered(final Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        LazyIterable<B> chunks = this.split();
        MutableList callables = chunks.collect(new Function<Batch<T>, Callable<V>>(){

            public Callable<V> valueOf(final Batch<T> chunk) {
                return new Callable<V>(){

                    @Override
                    public V call() {
                        return function.valueOf((Object)chunk);
                    }
                };
            }
        }).toList();
        final ExecutorCompletionService completionService = new ExecutorCompletionService(this.getExecutorService());
        callables.forEach(new Procedure<Callable<V>>(){

            public void value(Callable<V> callable) {
                completionService.submit(callable);
            }
        });
        for (int numTasks = callables.size(); numTasks > 0; --numTasks) {
            try {
                Future future = completionService.take();
                combineProcedure.value(state, future.get());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        try {
            appendable.append(start);
            Function map = new Function<Batch<T>, String>(){

                public String valueOf(Batch<T> batch) {
                    return batch.makeString(separator);
                }
            };
            CheckedProcedure2<Appendable, String> reduce = new CheckedProcedure2<Appendable, String>(){
                private boolean first = true;

                @Override
                public void safeValue(Appendable accumulator, String each) throws IOException {
                    if ("".equals(each)) {
                        return;
                    }
                    if (this.first) {
                        this.first = false;
                    } else {
                        appendable.append(separator);
                    }
                    appendable.append(each);
                }
            };
            this.collectCombine(map, reduce, appendable);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.forEach(Procedures.bind(procedure, parameter));
    }

    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.anySatisfy(Predicates.bind(predicate, parameter));
    }

    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.allSatisfy(Predicates.bind(predicate, parameter));
    }

    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return this.allSatisfy(Predicates.not(predicate));
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.noneSatisfy(Predicates.bind(predicate, parameter));
    }

    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (T)this.detect(Predicates.bind(predicate, parameter));
    }

    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        Object result = this.detect(predicate);
        return (T)(result == null ? function.value() : result);
    }

    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        return this.detectIfNone(Predicates.bind(predicate, parameter), function);
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toArray() not implemented yet");
    }

    public <E> E[] toArray(E[] array) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toArray() not implemented yet");
    }

    public MutableList<T> toList() {
        Function map = new Function<Batch<T>, FastList<T>>(){

            public FastList<T> valueOf(Batch<T> batch) {
                FastList list = FastList.newList();
                batch.forEach(CollectionAddProcedure.on(list));
                return list;
            }
        };
        Procedure2 reduce = new Procedure2<MutableList<T>, FastList<T>>(){

            public void value(MutableList<T> accumulator, FastList<T> each) {
                accumulator.addAll(each);
            }
        };
        CompositeFastList state = new CompositeFastList();
        this.collectCombine(map, reduce, state);
        return state;
    }

    public MutableList<T> toSortedList() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toSortedList() not implemented yet");
    }

    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toSortedList() not implemented yet");
    }

    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        return this.toSortedList((Comparator<? super T>)Comparators.byFunction(function));
    }

    public MutableSet<T> toSet() {
        MutableSet result = UnifiedSet.newSet().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public MutableSortedSet<T> toSortedSet() {
        MutableSortedSet result = TreeSortedSet.newSet().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        return this.toSortedSet((Comparator<? super T>)Comparators.byFunction(function));
    }

    public MutableBag<T> toBag() {
        MutableCollection result = HashBag.newBag().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        MutableSortedSet<? super T> result = TreeSortedSet.newSet(comparator).asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableMap map = UnifiedMap.newMap().asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(map, keyFunction, valueFunction));
        return map;
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableSortedMap sortedMap = TreeSortedMap.newMap().asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableSortedMap sortedMap = TreeSortedMap.newMap(comparator).asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        MutableMap map = UnifiedMap.newMap().asSynchronized();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        MutableMap map = UnifiedMap.newMap().asSynchronized();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public int count(Predicate<? super T> predicate) {
        AtomicCountProcedure<T> procedure = new AtomicCountProcedure<T>(predicate);
        this.forEach(procedure);
        return procedure.getCount();
    }

    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.count(Predicates.bind(predicate, parameter));
    }

    public T min(Comparator<? super T> comparator) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".min() not implemented yet");
    }

    public T max(Comparator<? super T> comparator) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".max() not implemented yet");
    }

    public T min() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".min() not implemented yet");
    }

    public T max() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".max() not implemented yet");
    }

    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".minBy() not implemented yet");
    }

    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".maxBy() not implemented yet");
    }

    public long sumOfInt(IntFunction<? super T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".sumOfInt() not implemented yet");
    }

    public double sumOfFloat(FloatFunction<? super T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".sumOfFloat() not implemented yet");
    }

    public long sumOfLong(LongFunction<? super T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".sumOfLong() not implemented yet");
    }

    public double sumOfDouble(DoubleFunction<? super T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".sumOfDouble() not implemented yet");
    }
}

