/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.bag.primitive.ImmutableDoubleBagFactory;
import com.gs.collections.api.bag.primitive.ImmutableDoubleBag;

/**
 * ImmutableDoubleBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleBagFactoryImpl implements ImmutableDoubleBagFactory
{
    public ImmutableDoubleBag of()
    {
        return this.with();
    }

    public ImmutableDoubleBag with()
    {
        return ImmutableDoubleEmptyBag.INSTANCE;
    }

    public ImmutableDoubleBag of(double one)
    {
        return this.with(one);
    }

    public ImmutableDoubleBag with(double one)
    {
        return new ImmutableDoubleSingletonBag(one);
    }

    public ImmutableDoubleBag of(double... items)
    {
        return this.with(items);
    }

    public ImmutableDoubleBag with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableDoubleHashBag.newBagWith(items);
    }

    public ImmutableDoubleBag ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableDoubleBag withAll(DoubleIterable items)
    {
        if (items instanceof ImmutableDoubleBag)
        {
            return (ImmutableDoubleBag) items;
        }
        return this.with(items.toArray());
    }
}
