/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.ImmutableIntList;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseIntIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableIntSingletonList is an optimization for {@link ImmutableIntList} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonList.stg.
 */
@Immutable
final class ImmutableIntSingletonList implements ImmutableIntList, Serializable
{
    private static final long serialVersionUID = 1L;
    private final int element1;

    ImmutableIntSingletonList(int element)
    {
        this.element1 = element;
    }

    public int get(int index)
    {
        if (index == 0)
        {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public int getFirst()
    {
        return this.element1;
    }

    public int getLast()
    {
        return this.element1;
    }

    public int indexOf(int value)
    {
        return this.element1 == value ? 0 : -1;
    }

    public int lastIndexOf(int value)
    {
        return this.element1 == value ? 0 : -1;
    }

    public IntIterator intIterator()
    {
        return IntArrayList.newListWith(this.element1).intIterator();
    }

    public void forEach(IntProcedure procedure)
    {
        procedure.value(this.element1);
    }

    public void forEachWithIndex(IntIntProcedure procedure)
    {
        procedure.value(this.element1, 0);
    }

    public int count(IntPredicate predicate)
    {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return !predicate.accept(this.element1);
    }

    public ImmutableIntList select(IntPredicate predicate)
    {
        return predicate.accept(this.element1) ? IntArrayList.newListWith(this.element1).toImmutable()
                : new IntArrayList().toImmutable();
    }

    public ImmutableIntList reject(IntPredicate predicate)
    {
        return predicate.accept(this.element1) ? new IntArrayList().toImmutable()
                : IntArrayList.newListWith(this.element1).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(IntToObjectFunction<? extends V> function)
    {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    public long sum()
    {
        return this.element1;
    }

    public int max()
    {
        return this.element1;
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.element1;
    }

    public int min()
    {
        return this.element1;
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.element1;
    }

    public double average()
    {
        return this.element1;
    }

    public double median()
    {
        return this.element1;
    }

    public int[] toSortedArray()
    {
        return new int[]{this.element1};
    }

    public MutableIntList toSortedList()
    {
        return IntArrayList.newListWith(this.element1);
    }

    public long dotProduct(IntList list)
    {
        if (list.size() != 1)
        {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return (long) this.element1 * list.getFirst();
    }

    public int[] toArray()
    {
        return new int[]{this.element1};
    }

    public boolean contains(int value)
    {
        return this.element1 == value;
    }

    public boolean containsAll(int... source)
    {
        for (int value : source)
        {
            if (this.element1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(IntIterable source)
    {
        for (IntIterator iterator = source.intIterator(); iterator.hasNext(); )
        {
            if (this.element1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public LazyIntIterable asReversed()
    {
        return ReverseIntIterable.adapt(this);
    }

    public MutableIntList toList()
    {
        return IntArrayList.newListWith(this.element1);
    }

    public MutableIntSet toSet()
    {
        return IntHashSet.newSetWith(this.element1);
    }

    public MutableIntBag toBag()
    {
        return IntHashBag.newBagWith(this.element1);
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public ImmutableIntList toImmutable()
    {
        return this;
    }

    public ImmutableIntSingletonList toReversed()
    {
        return this;
    }

    public ImmutableIntList newWith(int element)
    {
        return IntLists.immutable.with(this.element1, element);
    }

    public ImmutableIntList newWithout(int element)
    {
        return this.element1 == element ? IntLists.immutable.with() : this;
    }

    public ImmutableIntList newWithAll(IntIterable elements)
    {
        IntArrayList arrayList = IntArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableIntList newWithoutAll(IntIterable elements)
    {
        return elements.contains(this.element1) ? IntLists.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1, 0);
    }

    @Override
    public boolean equals(Object otherList)
    {
        if (otherList == this)
        {
            return true;
        }
        if (!(otherList instanceof IntList))
        {
            return false;
        }
        IntList list = (IntList) otherList;
        if (list.size() != 1)
        {
            return false;
        }
        return this.element1 == list.get(0);
    }

    @Override
    public int hashCode()
    {
        return 31 + this.element1;
    }

    @Override
    public String toString()
    {
        return "[" + this.element1 + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ImmutableIntList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
