/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.ByteCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteCharProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.ByteCharMap;
import com.gs.collections.api.map.primitive.ImmutableByteCharMap;
import com.gs.collections.api.map.primitive.MutableByteCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.ByteCharPair;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedByteCharProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.map.mutable.primitive.ByteCharHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

/**
 * ImmutableByteCharHashMap is the non-modifiable equivalent of {@link ByteCharHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 * @since 4.0.
 */
final class ImmutableByteCharHashMap implements ImmutableByteCharMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableByteCharMap delegate;

    ImmutableByteCharHashMap(ByteCharMap delegate)
    {
        this.delegate = new ByteCharHashMap(delegate);
    }

    public char get(byte key)
    {
        return this.delegate.get(key);
    }

    public char getIfAbsent(byte key, char ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(byte key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(byte key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(char value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteCharProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyByteIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ByteCharPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableByteCharMap select(ByteCharPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteCharMap reject(ByteCharPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return ((ByteCharHashMap) this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableByteCharMap toImmutable()
    {
        return this;
    }

    public CharIterator charIterator()
    {
        return this.delegate.charIterator();
    }

    public void forEach(CharProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(CharPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableCharCollection select(CharPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public char max()
    {
        return this.delegate.max();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public char min()
    {
        return this.delegate.min();
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public char[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableCharList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public char[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(char value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(char... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(CharIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableCharList toList()
    {
        return this.delegate.toList();
    }

    public MutableCharSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableCharBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyCharIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableByteCharMap newWithKeyValue(byte key, char value)
    {
        MutableByteCharMap map = new ByteCharHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableByteCharMap newWithoutKey(byte key)
    {
        MutableByteCharMap map = new ByteCharHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableByteCharMap newWithoutAllKeys(ByteIterable keys)
    {
        MutableByteCharMap map = new ByteCharHashMap(this.size());
        map.putAll(this);
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableByteSet keySet()
    {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableByteCharMapSerializationProxy(this);
    }

    protected static class ImmutableByteCharMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private ByteCharMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableByteCharMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableByteCharMapSerializationProxy(ByteCharMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedByteCharProcedure()
                {
                    @Override
                    public void safeValue(byte key, char value) throws IOException
                    {
                        out.writeByte(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableByteCharMap deserializedMap = new ByteCharHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readByte(), in.readChar());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
