/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.IntBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.IntBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.IntBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableIntBooleanMap;
import com.gs.collections.api.map.primitive.MutableIntBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.tuple.primitive.IntBooleanPair;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedIntBooleanProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.map.mutable.primitive.IntBooleanHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

/**
 * ImmutableIntBooleanHashMap is the non-modifiable equivalent of {@link IntBooleanHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 * @since 4.0.
 */
final class ImmutableIntBooleanHashMap implements ImmutableIntBooleanMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableIntBooleanMap delegate;

    ImmutableIntBooleanHashMap(IntBooleanMap delegate)
    {
        this.delegate = new IntBooleanHashMap(delegate);
    }

    public boolean get(int key)
    {
        return this.delegate.get(key);
    }

    public boolean getIfAbsent(int key, boolean ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(int key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(int key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(boolean value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(IntBooleanProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<IntBooleanPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableIntBooleanMap select(IntBooleanPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntBooleanMap reject(IntBooleanPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return ((IntBooleanHashMap) this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableIntBooleanMap toImmutable()
    {
        return this;
    }

    public BooleanIterator booleanIterator()
    {
        return this.delegate.booleanIterator();
    }

    public void forEach(BooleanProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(BooleanPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public boolean[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(boolean value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(boolean... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableBooleanList toList()
    {
        return this.delegate.toList();
    }

    public MutableBooleanSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableBooleanBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyBooleanIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableIntBooleanMap newWithKeyValue(int key, boolean value)
    {
        MutableIntBooleanMap map = new IntBooleanHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableIntBooleanMap newWithoutKey(int key)
    {
        MutableIntBooleanMap map = new IntBooleanHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableIntBooleanMap newWithoutAllKeys(IntIterable keys)
    {
        MutableIntBooleanMap map = new IntBooleanHashMap(this.size());
        map.putAll(this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    public MutableBooleanCollection values()
    {
        return UnmodifiableBooleanCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableIntBooleanMapSerializationProxy(this);
    }

    protected static class ImmutableIntBooleanMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private IntBooleanMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableIntBooleanMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableIntBooleanMapSerializationProxy(IntBooleanMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedIntBooleanProcedure()
                {
                    @Override
                    public void safeValue(int key, boolean value) throws IOException
                    {
                        out.writeInt(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableIntBooleanMap deserializedMap = new IntBooleanHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readInt(), in.readBoolean());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
