/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableLongIntMapFactory;
import com.gs.collections.api.map.primitive.ImmutableLongIntMap;
import com.gs.collections.api.map.primitive.LongIntMap;

/**
 * ImmutableLongIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongIntMapFactoryImpl implements ImmutableLongIntMapFactory
{
    public ImmutableLongIntMap of()
    {
        return this.with();
    }

    public ImmutableLongIntMap with()
    {
        return ImmutableLongIntEmptyMap.INSTANCE;
    }

    public ImmutableLongIntMap of(long key, int value)
    {
        return this.with(key, value);
    }

    public ImmutableLongIntMap with(long key, int value)
    {
        return new ImmutableLongIntSingletonMap(key, value);
    }

    public ImmutableLongIntMap ofAll(LongIntMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongIntMap withAll(LongIntMap map)
    {
        if (map instanceof ImmutableLongIntMap)
        {
            return (ImmutableLongIntMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongIntSingletonMap(key, map.get(key));
        }
        return new ImmutableLongIntHashMap(map);
    }
}
