/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortLongMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortLongMap;
import com.gs.collections.api.map.primitive.ShortLongMap;

/**
 * ImmutableShortLongMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortLongMapFactoryImpl implements ImmutableShortLongMapFactory
{
    public ImmutableShortLongMap of()
    {
        return this.with();
    }

    public ImmutableShortLongMap with()
    {
        return ImmutableShortLongEmptyMap.INSTANCE;
    }

    public ImmutableShortLongMap of(short key, long value)
    {
        return this.with(key, value);
    }

    public ImmutableShortLongMap with(short key, long value)
    {
        return new ImmutableShortLongSingletonMap(key, value);
    }

    public ImmutableShortLongMap ofAll(ShortLongMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortLongMap withAll(ShortLongMap map)
    {
        if (map instanceof ImmutableShortLongMap)
        {
            return (ImmutableShortLongMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortLongSingletonMap(key, map.get(key));
        }
        return new ImmutableShortLongHashMap(map);
    }
}
