/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.utility.internal.primitive;

import java.io.IOException;
import java.util.Collection;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;

/**
 * This file was automatically generated from template file primitiveIterableIterate.stg.
 *
 * @since 5.0
 */
public final class BooleanIterableIterate
{
    private BooleanIterableIterate()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(BooleanIterable iterable)
    {
        return !iterable.booleanIterator().hasNext();
    }

    public static boolean notEmpty(BooleanIterable iterable)
    {
        return !BooleanIterableIterate.isEmpty(iterable);
    }

    public static void forEach(BooleanIterable iterable, BooleanProcedure procedure)
    {
        BooleanIteratorIterate.forEach(iterable.booleanIterator(), procedure);
    }

    public static <R extends MutableBooleanCollection> R select(BooleanIterable iterable, BooleanPredicate predicate, R targetCollection)
    {
        return BooleanIteratorIterate.select(iterable.booleanIterator(), predicate, targetCollection);
    }

    public static <R extends MutableBooleanCollection> R reject(BooleanIterable iterable, BooleanPredicate predicate, R targetCollection)
    {
        return BooleanIteratorIterate.reject(iterable.booleanIterator(), predicate, targetCollection);
    }

    public static <V, R extends Collection<V>> R collect(
            BooleanIterable iterable,
            BooleanToObjectFunction<? extends V> function,
            R targetCollection)
    {
        return BooleanIteratorIterate.collect(iterable.booleanIterator(), function, targetCollection);
    }

    public static boolean detectIfNone(BooleanIterable iterable, BooleanPredicate predicate, boolean ifNone)
    {
        return BooleanIteratorIterate.detectIfNone(iterable.booleanIterator(), predicate, ifNone);
    }

    public static int count(BooleanIterable iterable, BooleanPredicate predicate)
    {
        return BooleanIteratorIterate.count(iterable.booleanIterator(), predicate);
    }

    public static boolean anySatisfy(BooleanIterable iterable, BooleanPredicate predicate)
    {
        return BooleanIteratorIterate.anySatisfy(iterable.booleanIterator(), predicate);
    }

    public static boolean allSatisfy(BooleanIterable iterable, BooleanPredicate predicate)
    {
        return BooleanIteratorIterate.allSatisfy(iterable.booleanIterator(), predicate);
    }

    public static boolean noneSatisfy(BooleanIterable iterable, BooleanPredicate predicate)
    {
        return BooleanIteratorIterate.noneSatisfy(iterable.booleanIterator(), predicate);
    }


    public static void appendString(
            BooleanIterable iterable,
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        try
        {
            appendable.append(start);

            BooleanIterator iterator = iterable.booleanIterator();
            if (iterator.hasNext())
            {
                appendable.append(stringValueOfItem(iterable, iterator.next()));
                while (iterator.hasNext())
                {
                    appendable.append(separator);
                    appendable.append(stringValueOfItem(iterable, iterator.next()));
                }
            }

            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public static <T> T injectInto(BooleanIterable iterable, T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return BooleanIteratorIterate.injectInto(iterable.booleanIterator(), injectedValue, function);
    }

    private static <T> String stringValueOfItem(BooleanIterable iterable, T item)
    {
        return item == iterable
                ? "(this " + iterable.getClass().getSimpleName() + ')'
                : String.valueOf(item);
    }
}
