/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.set.ParallelUnsortedSetIterable;
import com.gs.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import com.gs.collections.impl.lazy.parallel.set.AbstractParallelUnsortedSetIterable;
import com.gs.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class ParallelListDistinctIterable<T>
extends AbstractParallelUnsortedSetIterable<T, UnsortedSetBatch<T>> {
    private final AbstractParallelListIterable<T, ? extends ListBatch<T>> parallelIterable;

    ParallelListDistinctIterable(AbstractParallelListIterable<T, ? extends ListBatch<T>> parallelIterable) {
        this.parallelIterable = parallelIterable;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public LazyIterable<UnsortedSetBatch<T>> split() {
        final ConcurrentHashMap distinct = new ConcurrentHashMap();
        return this.parallelIterable.split().collect(new Function<ListBatch<T>, UnsortedSetBatch<T>>(){

            public UnsortedSetBatch<T> valueOf(ListBatch<T> listBatch) {
                return listBatch.distinct(distinct);
            }
        });
    }

    @Override
    public ParallelUnsortedSetIterable<T> asUnique() {
        return this;
    }

    public void forEach(final Procedure<? super T> procedure) {
        final ConcurrentHashMap distinct = new ConcurrentHashMap();
        this.parallelIterable.forEach(new Procedure<T>(){

            public void value(T each) {
                if (distinct.put(each, true) == null) {
                    procedure.value(each);
                }
            }
        });
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.anySatisfy(new DistinctAndPredicate(predicate));
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.allSatisfy(new DistinctOrPredicate(predicate));
    }

    public T detect(Predicate<? super T> predicate) {
        return (T)this.parallelIterable.detect(new DistinctAndPredicate(predicate));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DistinctOrPredicate<T>
    implements Predicate<T> {
        private final ConcurrentHashMap<T, Boolean> distinct = new ConcurrentHashMap();
        private final Predicate<? super T> predicate;

        private DistinctOrPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        public boolean accept(T each) {
            return this.distinct.put(each, true) == null || this.predicate.accept(each);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DistinctAndPredicate<T>
    implements Predicate<T> {
        private final ConcurrentHashMap<T, Boolean> distinct = new ConcurrentHashMap();
        private final Predicate<? super T> predicate;

        private DistinctAndPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        public boolean accept(T each) {
            return this.distinct.put(each, true) == null && this.predicate.accept(each);
        }
    }
}

