/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableCharSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableCharEmptySet
implements ImmutableCharSet,
Serializable {
    private static final long serialVersionUID = 1L;
    static final ImmutableCharSet INSTANCE = new ImmutableCharEmptySet();

    ImmutableCharEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableCharSet newWith(char element) {
        return new ImmutableCharSingletonSet(element);
    }

    public ImmutableCharSet newWithout(char element) {
        return this;
    }

    public ImmutableCharSet newWithAll(CharIterable elements) {
        return CharSets.immutable.withAll(elements);
    }

    public ImmutableCharSet newWithoutAll(CharIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(char value) {
        return false;
    }

    public boolean containsAll(CharIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(char ... elements) {
        return elements.length == 0;
    }

    public void forEach(CharProcedure procedure) {
    }

    public ImmutableCharSet select(CharPredicate predicate) {
        return this;
    }

    public ImmutableCharSet reject(CharPredicate predicate) {
        return this;
    }

    public <V> ImmutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    public MutableCharList toList() {
        return new CharArrayList();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return ifNone;
    }

    public int count(CharPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return false;
    }

    public long sum() {
        return 0L;
    }

    public char min() {
        throw new NoSuchElementException();
    }

    public char max() {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue) {
        return defaultValue;
    }

    public char minIfEmpty(char defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public char[] toSortedArray() {
        return new char[0];
    }

    public MutableCharList toSortedList() {
        return new CharArrayList();
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharSet)) {
            return false;
        }
        CharSet set = (CharSet)obj;
        return set.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableCharSet toSet() {
        return new CharHashSet();
    }

    public MutableCharBag toBag() {
        return new CharHashBag();
    }

    public CharSet freeze() {
        return this;
    }

    public ImmutableCharSet toImmutable() {
        return this;
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public char[] toArray() {
        return new char[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    private static class InternalCharIterator
    implements CharIterator {
        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public char next() {
            throw new NoSuchElementException();
        }
    }
}

