/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.LongList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableLongStack;
import com.gs.collections.api.stack.primitive.MutableLongStack;
import com.gs.collections.impl.factory.primitive.LongStacks;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedLongStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableLongStack
implements MutableLongStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongStack stack;

    UnmodifiableLongStack(MutableLongStack stack) {
        this.stack = stack;
    }

    public void push(long item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public long pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public LongList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public long peek() {
        return this.stack.peek();
    }

    public LongList peek(int count) {
        return this.stack.peek(count);
    }

    public long peekAt(int index) {
        return this.stack.peekAt(index);
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(long value) {
        return this.stack.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.stack.containsAll(source);
    }

    public LongIterator longIterator() {
        return this.stack.longIterator();
    }

    public void forEach(LongProcedure procedure) {
        this.stack.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableLongStack select(LongPredicate predicate) {
        return this.stack.select(predicate);
    }

    public MutableLongStack reject(LongPredicate predicate) {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    public long sum() {
        return this.stack.sum();
    }

    public long max() {
        return this.stack.max();
    }

    public long min() {
        return this.stack.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    public long maxIfEmpty(long defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.stack.average();
    }

    public double median() {
        return this.stack.median();
    }

    public MutableLongList toSortedList() {
        return this.stack.toSortedList();
    }

    public long[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    public long[] toArray() {
        return this.stack.toArray();
    }

    public String toString() {
        return this.stack.toString();
    }

    public String makeString() {
        return this.stack.makeString();
    }

    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableLongList toList() {
        return this.stack.toList();
    }

    public MutableLongSet toSet() {
        return this.stack.toSet();
    }

    public MutableLongBag toBag() {
        return this.stack.toBag();
    }

    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    public int hashCode() {
        return this.stack.hashCode();
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public MutableLongStack asUnmodifiable() {
        return this;
    }

    public MutableLongStack asSynchronized() {
        return new SynchronizedLongStack(this);
    }

    public ImmutableLongStack toImmutable() {
        return LongStacks.immutable.withAllReversed((LongIterable)this);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)this.stack.injectInto(injectedValue, function);
    }
}

