/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.parallel;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;

public interface OrderedBatch<T> extends Batch<T>
{
    OrderedBatch<T> select(Predicate<? super T> predicate);

    <V> ListBatch<V> collect(Function<? super T, ? extends V> function);

    Batch<T> distinct(ConcurrentHashMap<T, Boolean> distinct);
}
