/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableBooleanListFactory;
import com.gs.collections.api.list.primitive.ImmutableBooleanList;

/**
 * ImmutableBooleanListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableBooleanList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableBooleanListFactoryImpl implements ImmutableBooleanListFactory
{
    public ImmutableBooleanList empty()
    {
        return ImmutableBooleanEmptyList.INSTANCE;
    }

    public ImmutableBooleanList of()
    {
        return this.empty();
    }

    public ImmutableBooleanList with()
    {
        return this.empty();
    }

    public ImmutableBooleanList of(boolean one)
    {
        return this.with(one);
    }

    public ImmutableBooleanList with(boolean one)
    {
        return new ImmutableBooleanSingletonList(one);
    }

    public ImmutableBooleanList of(boolean... items)
    {
        return this.with(items);
    }

    public ImmutableBooleanList with(boolean... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableBooleanArrayList.newListWith(items);
    }

    public ImmutableBooleanList ofAll(BooleanIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableBooleanList withAll(BooleanIterable items)
    {
        if (items instanceof ImmutableBooleanList)
        {
            return (ImmutableBooleanList) items;
        }
        return this.with(items.toArray());
    }
}
