/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.factory.list.primitive.MutableCharListFactory;
import com.gs.collections.api.list.primitive.MutableCharList;

/**
 * MutableCharListFactoryImpl is a factory implementation which creates instances of type {@link MutableCharList}.
 * This file was automatically generated from template file mutablePrimitiveListFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableCharListFactoryImpl implements MutableCharListFactory
{
    public MutableCharList empty()
    {
        return new CharArrayList();
    }

    public MutableCharList of()
    {
        return this.empty();
    }

    public MutableCharList with()
    {
        return this.empty();
    }

    public MutableCharList of(char... items)
    {
        return this.with(items);
    }

    public MutableCharList with(char... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return CharArrayList.newListWith(items);
    }

    public MutableCharList ofAll(CharIterable items)
    {
        return this.withAll(items);
    }

    public MutableCharList withAll(CharIterable items)
    {
        return CharArrayList.newList(items);
    }
}
