/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ByteFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ByteFloatMap;
import com.gs.collections.api.map.primitive.ImmutableByteFloatMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.ByteFloatPair;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.iterator.ImmutableEmptyFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyByteIterate;

/**
 * ImmutableByteFloatEmptyMap is an optimization for {@link ImmutableByteFloatMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableByteFloatEmptyMap implements ImmutableByteFloatMap, Serializable
{
    static final ImmutableByteFloatMap INSTANCE = new ImmutableByteFloatEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public float get(byte key)
    {
        return EMPTY_VALUE;
    }

    public float getIfAbsent(byte key, float ifAbsent)
    {
        return ifAbsent;
    }

    public float getOrThrow(byte key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key)
    {
        return false;
    }

    public boolean containsValue(float value)
    {
        return false;
    }

    public void forEachValue(FloatProcedure procedure)
    {
    }

    public void forEachKey(ByteProcedure procedure)
    {
    }

    public void forEachKeyValue(ByteFloatProcedure procedure)
    {
    }

    public LazyByteIterable keysView()
    {
        return LazyByteIterate.empty();
    }

    public RichIterable<ByteFloatPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableByteFloatMap select(ByteFloatPredicate predicate)
    {
        return this;
    }

    public ImmutableByteFloatMap reject(ByteFloatPredicate predicate)
    {
        return this;
    }

    public ImmutableByteFloatMap toImmutable()
    {
        return this;
    }

    public FloatIterator floatIterator()
    {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }

    public void forEach(FloatProcedure procedure)
    {
    }

    public int count(FloatPredicate predicate)
    {
        return 0;
    }

    public double sum()
    {
        return 0.0;
    }

    public float min()
    {
        throw new NoSuchElementException();
    }

    public float max()
    {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public float minIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public float[] toSortedArray()
    {
        return new float[0];
    }

    public MutableFloatList toSortedList()
    {
        return new FloatArrayList();
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public ImmutableFloatCollection select(FloatPredicate predicate)
    {
        return FloatLists.immutable.with();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate)
    {
        return FloatLists.immutable.with();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public float[] toArray()
    {
        return new float[0];
    }

    public boolean contains(float value)
    {
        return false;
    }

    public boolean containsAll(float... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(FloatIterable source)
    {
        return source.isEmpty();
    }

    public MutableFloatList toList()
    {
        return new FloatArrayList();
    }

    public MutableFloatSet toSet()
    {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag()
    {
        return new FloatHashBag();
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public ImmutableByteFloatMap newWithKeyValue(byte key, float value)
    {
        return new ImmutableByteFloatSingletonMap(key, value);
    }

    public ImmutableByteFloatMap newWithoutKey(byte key)
    {
        return this;
    }

    public ImmutableByteFloatMap newWithoutAllKeys(ByteIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableByteSet keySet()
    {
        return UnmodifiableByteSet.of(new ByteHashSet());
    }

    public MutableFloatCollection values()
    {
        return UnmodifiableFloatCollection.of(new FloatArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ByteFloatMap))
        {
            return false;
        }
        ByteFloatMap map = (ByteFloatMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
