/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleToIntFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleIntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.MutableIntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableDoubleIntMap;
import com.gs.collections.api.map.primitive.DoubleIntMap;
import com.gs.collections.api.map.primitive.MutableDoubleIntMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.DoubleIntPair;
import com.gs.collections.impl.factory.primitive.DoubleIntMaps;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableDoubleIntMap
        implements MutableDoubleIntMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableDoubleIntMap map;

    UnmodifiableDoubleIntMap(MutableDoubleIntMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(double key, int value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(DoubleIntMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(double key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(double key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public int removeKeyIfAbsent(double key, int value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public int getIfAbsentPut(double key, int value)
    {
        return this.map.getIfAbsentPut(key, new IntFunction0()
        {
            public int value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public int getIfAbsentPut(double key, IntFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new IntFunction0()
        {
            public int value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public int getIfAbsentPutWithKey(double key, DoubleToIntFunction function)
    {
        return this.map.getIfAbsentPut(key, new IntFunction0()
        {
            public int value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> int getIfAbsentPutWith(double key, IntFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new IntFunction0()
        {
            public int value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public int updateValue(double key, int initialValueIfAbsent, IntToIntFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public int get(double key)
    {
        return this.map.get(key);
    }

    public int getIfAbsent(double key, int ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(double key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(double key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(int value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleIntProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<DoubleIntPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableDoubleIntMap select(DoubleIntPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableDoubleIntMap reject(DoubleIntPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableIntIterator intIterator()
    {
        return new UnmodifiableIntIterator(this.map.intIterator());
    }

    public void forEach(IntProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(IntPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableIntCollection select(IntPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableIntCollection reject(IntPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public int max()
    {
        return this.map.max();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public int min()
    {
        return this.map.min();
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public int addToValue(double key, int toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public int[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableIntList toSortedList()
    {
        return this.map.toSortedList();
    }

    public int[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(int value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(int... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(IntIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableIntList toList()
    {
        return this.map.toList();
    }

    public MutableIntSet toSet()
    {
        return this.map.toSet();
    }

    public MutableIntBag toBag()
    {
        return this.map.toBag();
    }

    public LazyIntIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableDoubleIntMap withKeyValue(double key, int value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleIntMap withoutKey(double key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleIntMap withoutAllKeys(DoubleIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleIntMap asUnmodifiable()
    {
        return this;
    }

    public MutableDoubleIntMap asSynchronized()
    {
        return new SynchronizedDoubleIntMap(this);
    }

    public ImmutableDoubleIntMap toImmutable()
    {
        return DoubleIntMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(this.map.keySet());
    }

    public MutableIntCollection values()
    {
        return UnmodifiableIntCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
