/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.list.ParallelListIterable;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.list.ListMultimap;
import com.gs.collections.api.set.ParallelUnsortedSetIterable;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import com.gs.collections.impl.lazy.parallel.list.ParallelCollectListIterable;
import com.gs.collections.impl.lazy.parallel.list.ParallelDistinctListIterable;
import com.gs.collections.impl.lazy.parallel.list.ParallelSelectListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractParallelListIterable<T, B extends ListBatch<T>>
extends AbstractParallelIterable<T, B>
implements ParallelListIterable<T> {
    @Override
    protected boolean isOrdered() {
        return true;
    }

    public ParallelUnsortedSetIterable<T> asUnique() {
        return new ParallelDistinctListIterable(this);
    }

    public ParallelListIterable<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectListIterable<T>(this, predicate);
    }

    public <P> ParallelListIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <S> ParallelListIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.select((Predicate<? super T>)Predicates.instanceOf(clazz));
    }

    public ParallelListIterable<T> reject(Predicate<? super T> predicate) {
        return this.select((Predicate<? super T>)Predicates.not(predicate));
    }

    public <P> ParallelListIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public <V> ParallelListIterable<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectListIterable<T, V>(this, function);
    }

    public <P, V> ParallelListIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    public <V> ParallelListIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select(predicate).collect(function);
    }

    public <V> ParallelListIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.toList().flatCollect(function).asParallel(this.getExecutorService(), this.getBatchSize());
    }

    public <V> ListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.toList().groupBy(function);
    }

    public <V> ListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.toList().groupByEach(function);
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.toList().groupByUniqueKey(function);
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.toList().toArray((Object[])array);
    }
}

