/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.lazy.parallel.AbstractBatch;
import com.gs.collections.impl.lazy.parallel.Batch;
import com.gs.collections.impl.lazy.parallel.set.CollectUnsortedSetBatch;
import com.gs.collections.impl.lazy.parallel.set.SelectUnsortedSetBatch;
import com.gs.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class DistinctBatch<T>
extends AbstractBatch<T>
implements UnsortedSetBatch<T> {
    private final Batch<T> batch;
    private final ConcurrentHashMap<T, Boolean> distinct;

    public DistinctBatch(Batch<T> batch, ConcurrentHashMap<T, Boolean> distinct) {
        this.batch = batch;
        this.distinct = distinct;
    }

    @Override
    public void forEach(final Procedure<? super T> procedure) {
        this.batch.forEach(new Procedure<T>(){

            public void value(T each) {
                if (DistinctBatch.this.distinct.put(each, true) == null) {
                    procedure.value(each);
                }
            }
        });
    }

    @Override
    public UnsortedSetBatch<T> select(Predicate<? super T> predicate) {
        return new SelectUnsortedSetBatch<T>(this, predicate);
    }

    @Override
    public <V> UnsortedSetBatch<V> collect(Function<? super T, ? extends V> function) {
        return new CollectUnsortedSetBatch<T, V>(this, function);
    }
}

