/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.primitive.ByteToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ByteFloatPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ByteFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.MutableByteIterator;
import com.gs.collections.api.iterator.MutableFloatIterator;
import com.gs.collections.api.map.primitive.ByteFloatMap;
import com.gs.collections.api.map.primitive.ImmutableByteFloatMap;
import com.gs.collections.api.map.primitive.MutableByteFloatMap;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.ByteFloatPair;
import com.gs.collections.impl.factory.primitive.ByteFloatMaps;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableByteKeySet;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableFloatValuesMap;
import com.gs.collections.impl.map.mutable.primitive.ImmutableByteMapKeySet;
import com.gs.collections.impl.map.mutable.primitive.MutableByteKeysMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedByteFloatMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableByteFloatMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteFloatHashMap
extends AbstractMutableFloatValuesMap
implements MutableByteFloatMap,
Externalizable,
MutableByteKeysMap {
    private static final float EMPTY_VALUE = 0.0f;
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private byte[] keys;
    private float[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableFloatValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public ByteFloatHashMap() {
        this.allocateTable(16);
    }

    public ByteFloatHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public ByteFloatHashMap(ByteFloatMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static ByteFloatHashMap newWithKeysValues(byte key1, float value1) {
        return new ByteFloatHashMap(1).withKeyValue(key1, value1);
    }

    public static ByteFloatHashMap newWithKeysValues(byte key1, float value1, byte key2, float value2) {
        return new ByteFloatHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ByteFloatHashMap newWithKeysValues(byte key1, float value1, byte key2, float value2, byte key3, float value3) {
        return new ByteFloatHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ByteFloatHashMap newWithKeysValues(byte key1, float value1, byte key2, float value2, byte key3, float value3, byte key4, float value4) {
        return new ByteFloatHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableFloatValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected float getEmptyValue() {
        return 0.0f;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected float getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteFloatMap)) {
            return false;
        }
        ByteFloatMap other = (ByteFloatMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((byte)0) || Float.compare(this.sentinelValues.zeroValue, other.getOrThrow((byte)0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((byte)1) || Float.compare(this.sentinelValues.oneValue, other.getOrThrow((byte)1)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteFloatHashMap.isNonSentinel(key) || other.containsKey(key) && Float.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ Float.floatToIntBits(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ Float.floatToIntBits(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ Float.floatToIntBits(this.values[i]);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteFloatHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableFloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectFloatToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, 0.0f);
    }

    public void put(byte key, float value) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(float value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(float value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(ByteFloatMap map) {
        map.forEachKeyValue(new ByteFloatProcedure(){

            public void value(byte key, float value) {
                ByteFloatHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(byte key) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(byte key) {
        this.removeKey(key);
    }

    public float removeKeyIfAbsent(byte key, float value) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            float oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            float oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            float oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public float getIfAbsentPut(byte key, float value) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float getIfAbsentPut(byte key, FloatFunction0 function) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.value();
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.value();
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        float value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> float getIfAbsentPutWith(byte key, FloatFunction<? super P> function, P parameter) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.floatValueOf(parameter);
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.floatValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.floatValueOf(parameter);
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.floatValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        float value = function.floatValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float getIfAbsentPutWithKey(byte key, ByteToFloatFunction function) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        float value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float addToValue(byte key, float toBeAdded) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(byte key, float value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0.0f;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
        if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
            this.rehash();
        }
    }

    private void copyKeys() {
        byte[] copy = new byte[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public float updateValue(byte key, float initialValueIfAbsent, FloatToFloatFunction function) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        float value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public ByteFloatHashMap withKeyValue(byte key1, float value1) {
        this.put(key1, value1);
        return this;
    }

    public ByteFloatHashMap withKeysValues(byte key1, float value1, byte key2, float value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteFloatHashMap withKeysValues(byte key1, float value1, byte key2, float value2, byte key3, float value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteFloatHashMap withKeysValues(byte key1, float value1, byte key2, float value2, byte key3, float value3, byte key4, float value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ByteFloatHashMap withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    public ByteFloatHashMap withoutAllKeys(ByteIterable keys) {
        keys.forEach(new ByteProcedure(){

            public void value(byte key) {
                ByteFloatHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableByteFloatMap asUnmodifiable() {
        return new UnmodifiableByteFloatMap(this);
    }

    public MutableByteFloatMap asSynchronized() {
        return new SynchronizedByteFloatMap(this);
    }

    public ImmutableByteFloatMap toImmutable() {
        return ByteFloatMaps.immutable.ofAll((ByteFloatMap)this);
    }

    public float get(byte key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getIfAbsent(byte key, float ifAbsent) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public float getOrThrow(byte key) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ByteFloatHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(byte key) {
        if (ByteFloatHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ByteFloatHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(ByteFloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyByteIterable keysView() {
        return new KeysView();
    }

    public RichIterable<ByteFloatPair> keyValuesView() {
        return new KeyValuesView();
    }

    public ByteFloatHashMap select(ByteFloatPredicate predicate) {
        ByteFloatHashMap result = new ByteFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ByteFloatHashMap reject(ByteFloatPredicate predicate) {
        ByteFloatHashMap result = new ByteFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeByte(0);
                out.writeFloat(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeByte(1);
                out.writeFloat(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteFloatHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeByte(this.keys[i]);
            out.writeFloat(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readByte(), in.readFloat());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        byte[] old = this.keys;
        float[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteFloatHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(byte element) {
        int index = this.spread(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(byte element) {
        return this.mask(element);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new byte[sizeToAllocate];
        this.values = new float[sizeToAllocate];
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteFloatHashMap.isEmptyKey(key) && !ByteFloatHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !ByteFloatHashMap.isEmptyKey(this.keys[index]) && !ByteFloatHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    public MutableByteSet keySet() {
        return new KeySet();
    }

    public MutableFloatCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ byte[] access$302(ByteFloatHashMap x0, byte[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ float[] access$502(ByteFloatHashMap x0, float[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ByteFloatPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ByteFloatPair> procedure) {
            if (ByteFloatHashMap.this.sentinelValues != null) {
                if (((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.zeroValue));
                }
                if (((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ByteFloatHashMap.this.keys.length; ++i) {
                if (!ByteFloatHashMap.isNonSentinel(ByteFloatHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteFloatHashMap.this.keys[i], ByteFloatHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ByteFloatPair> objectIntProcedure) {
            int index = 0;
            if (ByteFloatHashMap.this.sentinelValues != null) {
                if (((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ByteFloatHashMap.this.keys.length; ++i) {
                if (!ByteFloatHashMap.isNonSentinel(ByteFloatHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(ByteFloatHashMap.this.keys[i], ByteFloatHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ByteFloatPair, ? super P> procedure, P parameter) {
            if (ByteFloatHashMap.this.sentinelValues != null) {
                if (((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ByteFloatHashMap.this.keys.length; ++i) {
                if (!ByteFloatHashMap.isNonSentinel(ByteFloatHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteFloatHashMap.this.keys[i], ByteFloatHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ByteFloatPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ByteFloatPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ByteFloatPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ByteFloatHashMap.this.containsKey((byte)0)) {
                        return PrimitiveTuples.pair((byte)0, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ByteFloatHashMap.this.containsKey((byte)1)) {
                        return PrimitiveTuples.pair((byte)1, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.oneValue);
                    }
                }
                byte[] keys = ByteFloatHashMap.this.keys;
                while (!ByteFloatHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ByteFloatPair result = PrimitiveTuples.pair(keys[this.position], ByteFloatHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ByteFloatHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableFloatValuesMap.AbstractFloatValuesCollection {
        private ValuesCollection() {
        }

        public MutableFloatIterator floatIterator() {
            return ByteFloatHashMap.this.floatIterator();
        }

        public boolean remove(float item) {
            int oldSize = ByteFloatHashMap.this.size();
            if (ByteFloatHashMap.this.sentinelValues != null) {
                if (((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsZeroKey && Float.compare(item, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.zeroValue) == 0) {
                    ByteFloatHashMap.this.removeKey((byte)0);
                }
                if (((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsOneKey && Float.compare(item, ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.oneValue) == 0) {
                    ByteFloatHashMap.this.removeKey((byte)1);
                }
            }
            for (int i = 0; i < ByteFloatHashMap.this.keys.length; ++i) {
                if (!ByteFloatHashMap.isNonSentinel(ByteFloatHashMap.this.keys[i]) || Float.compare(item, ByteFloatHashMap.this.values[i]) != 0) continue;
                ByteFloatHashMap.this.removeKey(ByteFloatHashMap.this.keys[i]);
            }
            return oldSize != ByteFloatHashMap.this.size();
        }

        public boolean retainAll(FloatIterable source) {
            int oldSize = ByteFloatHashMap.this.size();
            Object sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
            ByteFloatHashMap retained = ByteFloatHashMap.this.select(new ByteFloatPredicate((FloatSet)sourceSet){
                final /* synthetic */ FloatSet val$sourceSet;
                {
                    this.val$sourceSet = floatSet;
                }

                public boolean accept(byte key, float value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                ByteFloatHashMap.access$302(ByteFloatHashMap.this, retained.keys);
                ByteFloatHashMap.access$502(ByteFloatHashMap.this, retained.values);
                ByteFloatHashMap.this.sentinelValues = retained.sentinelValues;
                ByteFloatHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteFloatHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableByteKeySet {
        private KeySet() {
        }

        protected MutableByteKeysMap getOuter() {
            return ByteFloatHashMap.this;
        }

        protected AbstractMutableFloatValuesMap.SentinelValues getSentinelValues() {
            return ByteFloatHashMap.this.sentinelValues;
        }

        protected byte getKeyAtIndex(int index) {
            return ByteFloatHashMap.this.keys[index];
        }

        protected int getTableSize() {
            return ByteFloatHashMap.this.keys.length;
        }

        public MutableByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = ByteFloatHashMap.this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            ByteFloatHashMap retained = ByteFloatHashMap.this.select(new ByteFloatPredicate((ByteSet)sourceSet){
                final /* synthetic */ ByteSet val$sourceSet;
                {
                    this.val$sourceSet = byteSet;
                }

                public boolean accept(byte key, float value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                ByteFloatHashMap.access$302(ByteFloatHashMap.this, retained.keys);
                ByteFloatHashMap.access$502(ByteFloatHashMap.this, retained.values);
                ByteFloatHashMap.this.sentinelValues = retained.sentinelValues;
                ByteFloatHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteFloatHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(byte ... source) {
            return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
        }

        public ByteSet freeze() {
            ByteFloatHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (ByteFloatHashMap.this.sentinelValues != null) {
                containsZeroKey = ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((ByteFloatHashMap)ByteFloatHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableByteMapKeySet(ByteFloatHashMap.this.keys, ByteFloatHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteFloatHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteFloatHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteFloatHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            byte[] keys = ByteFloatHashMap.this.keys;
            while (!ByteFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ByteFloatHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyByteIterable {
        private KeysView() {
        }

        public ByteIterator byteIterator() {
            return new UnmodifiableByteIterator((ByteIterator)new KeySetIterator());
        }

        public void forEach(ByteProcedure procedure) {
            ByteFloatHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalFloatIterator
    implements MutableFloatIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteFloatHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteFloatHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return ByteFloatHashMap.this.get((byte)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteFloatHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return ByteFloatHashMap.this.get((byte)1);
                }
            }
            byte[] keys = ByteFloatHashMap.this.keys;
            while (!ByteFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            float result = ByteFloatHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ByteFloatHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

