/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.primitive.CharToIntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharIntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.MutableCharIterator;
import com.gs.collections.api.iterator.MutableIntIterator;
import com.gs.collections.api.map.primitive.CharIntMap;
import com.gs.collections.api.map.primitive.ImmutableCharIntMap;
import com.gs.collections.api.map.primitive.MutableCharIntMap;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.CharIntPair;
import com.gs.collections.impl.factory.primitive.CharIntMaps;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableCharKeySet;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableIntValuesMap;
import com.gs.collections.impl.map.mutable.primitive.ImmutableCharMapKeySet;
import com.gs.collections.impl.map.mutable.primitive.MutableCharKeysMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedCharIntMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableCharIntMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharIntHashMap
extends AbstractMutableIntValuesMap
implements MutableCharIntMap,
Externalizable,
MutableCharKeysMap {
    private static final int EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private char[] keys;
    private int[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableIntValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public CharIntHashMap() {
        this.allocateTable(16);
    }

    public CharIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public CharIntHashMap(CharIntMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static CharIntHashMap newWithKeysValues(char key1, int value1) {
        return new CharIntHashMap(1).withKeyValue(key1, value1);
    }

    public static CharIntHashMap newWithKeysValues(char key1, int value1, char key2, int value2) {
        return new CharIntHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static CharIntHashMap newWithKeysValues(char key1, int value1, char key2, int value2, char key3, int value3) {
        return new CharIntHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static CharIntHashMap newWithKeysValues(char key1, int value1, char key2, int value2, char key3, int value3, char key4, int value4) {
        return new CharIntHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableIntValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected int getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected int getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharIntMap)) {
            return false;
        }
        CharIntMap other = (CharIntMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey('\u0000') || this.sentinelValues.zeroValue != other.getOrThrow('\u0000'))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey('\u0001') || this.sentinelValues.oneValue != other.getOrThrow('\u0001'))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharIntHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append('\u0000').append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append('\u0001').append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharIntHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableIntIterator intIterator() {
        return new InternalIntIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharIntHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, 0);
    }

    public void put(char key, int value) {
        if (CharIntHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(int value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(int value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(CharIntMap map) {
        map.forEachKeyValue(new CharIntProcedure(){

            public void value(char key, int value) {
                CharIntHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(char key) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(char key) {
        this.removeKey(key);
    }

    public int removeKeyIfAbsent(char key, int value) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            int oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            int oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public int getIfAbsentPut(char key, int value) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int getIfAbsentPut(char key, IntFunction0 function) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.value();
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> int getIfAbsentPutWith(char key, IntFunction<? super P> function, P parameter) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.intValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.intValueOf(parameter);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.intValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.intValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int getIfAbsentPutWithKey(char key, CharToIntFunction function) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        int value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public int addToValue(char key, int toBeAdded) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(char key, int value, int index) {
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = '\u0001';
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
        if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
            this.rehash();
        }
    }

    private void copyKeys() {
        char[] copy = new char[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public int updateValue(char key, int initialValueIfAbsent, IntToIntFunction function) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableIntValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        int value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public CharIntHashMap withKeyValue(char key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public CharIntHashMap withKeysValues(char key1, int value1, char key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharIntHashMap withKeysValues(char key1, int value1, char key2, int value2, char key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharIntHashMap withKeysValues(char key1, int value1, char key2, int value2, char key3, int value3, char key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public CharIntHashMap withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    public CharIntHashMap withoutAllKeys(CharIterable keys) {
        keys.forEach(new CharProcedure(){

            public void value(char key) {
                CharIntHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableCharIntMap asUnmodifiable() {
        return new UnmodifiableCharIntMap(this);
    }

    public MutableCharIntMap asSynchronized() {
        return new SynchronizedCharIntMap(this);
    }

    public ImmutableCharIntMap toImmutable() {
        return CharIntMaps.immutable.ofAll((CharIntMap)this);
    }

    public int get(char key) {
        return this.getIfAbsent(key, 0);
    }

    public int getIfAbsent(char key, int ifAbsent) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public int getOrThrow(char key) {
        if (CharIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (CharIntHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(char key) {
        if (CharIntHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (CharIntHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(CharIntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyCharIterable keysView() {
        return new KeysView();
    }

    public RichIterable<CharIntPair> keyValuesView() {
        return new KeyValuesView();
    }

    public CharIntHashMap select(CharIntPredicate predicate) {
        CharIntHashMap result = new CharIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public CharIntHashMap reject(CharIntPredicate predicate) {
        CharIntHashMap result = new CharIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeChar(0);
                out.writeInt(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeChar(1);
                out.writeInt(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharIntHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readInt());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        int[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharIntHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(char element) {
        int index = this.spread(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == '\u0001') {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == '\u0000') break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(char element) {
        int code = element;
        code ^= code >>> 15;
        code *= 1854960195;
        code ^= code >>> 13;
        code *= -75769267;
        code ^= code >>> 11;
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new int[sizeToAllocate];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharIntHashMap.isEmptyKey(key) && !CharIntHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !CharIntHashMap.isEmptyKey(this.keys[index]) && !CharIntHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    public MutableCharSet keySet() {
        return new KeySet();
    }

    public MutableIntCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ char[] access$302(CharIntHashMap x0, char[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(CharIntHashMap x0, int[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<CharIntPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super CharIntPair> procedure) {
            if (CharIntHashMap.this.sentinelValues != null) {
                if (((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', ((CharIntHashMap)CharIntHashMap.this).sentinelValues.zeroValue));
                }
                if (((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', ((CharIntHashMap)CharIntHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < CharIntHashMap.this.keys.length; ++i) {
                if (!CharIntHashMap.isNonSentinel(CharIntHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharIntHashMap.this.keys[i], CharIntHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super CharIntPair> objectIntProcedure) {
            int index = 0;
            if (CharIntHashMap.this.sentinelValues != null) {
                if (((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0000', ((CharIntHashMap)CharIntHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0001', ((CharIntHashMap)CharIntHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharIntHashMap.this.keys.length; ++i) {
                if (!CharIntHashMap.isNonSentinel(CharIntHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(CharIntHashMap.this.keys[i], CharIntHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super CharIntPair, ? super P> procedure, P parameter) {
            if (CharIntHashMap.this.sentinelValues != null) {
                if (((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', ((CharIntHashMap)CharIntHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', ((CharIntHashMap)CharIntHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < CharIntHashMap.this.keys.length; ++i) {
                if (!CharIntHashMap.isNonSentinel(CharIntHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharIntHashMap.this.keys[i], CharIntHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<CharIntPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<CharIntPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharIntPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharIntHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', ((CharIntHashMap)CharIntHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharIntHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', ((CharIntHashMap)CharIntHashMap.this).sentinelValues.oneValue);
                    }
                }
                char[] keys = CharIntHashMap.this.keys;
                while (!CharIntHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                CharIntPair result = PrimitiveTuples.pair(keys[this.position], CharIntHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharIntHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableIntValuesMap.AbstractIntValuesCollection {
        private ValuesCollection() {
        }

        public MutableIntIterator intIterator() {
            return CharIntHashMap.this.intIterator();
        }

        public boolean remove(int item) {
            int oldSize = CharIntHashMap.this.size();
            if (CharIntHashMap.this.sentinelValues != null) {
                if (((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsZeroKey && item == ((CharIntHashMap)CharIntHashMap.this).sentinelValues.zeroValue) {
                    CharIntHashMap.this.removeKey('\u0000');
                }
                if (((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsOneKey && item == ((CharIntHashMap)CharIntHashMap.this).sentinelValues.oneValue) {
                    CharIntHashMap.this.removeKey('\u0001');
                }
            }
            for (int i = 0; i < CharIntHashMap.this.keys.length; ++i) {
                if (!CharIntHashMap.isNonSentinel(CharIntHashMap.this.keys[i]) || item != CharIntHashMap.this.values[i]) continue;
                CharIntHashMap.this.removeKey(CharIntHashMap.this.keys[i]);
            }
            return oldSize != CharIntHashMap.this.size();
        }

        public boolean retainAll(IntIterable source) {
            int oldSize = CharIntHashMap.this.size();
            Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            CharIntHashMap retained = CharIntHashMap.this.select(new CharIntPredicate((IntSet)sourceSet){
                final /* synthetic */ IntSet val$sourceSet;
                {
                    this.val$sourceSet = intSet;
                }

                public boolean accept(char key, int value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                CharIntHashMap.access$302(CharIntHashMap.this, retained.keys);
                CharIntHashMap.access$502(CharIntHashMap.this, retained.values);
                CharIntHashMap.this.sentinelValues = retained.sentinelValues;
                CharIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableCharKeySet {
        private KeySet() {
        }

        protected MutableCharKeysMap getOuter() {
            return CharIntHashMap.this;
        }

        protected AbstractMutableIntValuesMap.SentinelValues getSentinelValues() {
            return CharIntHashMap.this.sentinelValues;
        }

        protected char getKeyAtIndex(int index) {
            return CharIntHashMap.this.keys[index];
        }

        protected int getTableSize() {
            return CharIntHashMap.this.keys.length;
        }

        public MutableCharIterator charIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = CharIntHashMap.this.size();
            Object sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            CharIntHashMap retained = CharIntHashMap.this.select(new CharIntPredicate((CharSet)sourceSet){
                final /* synthetic */ CharSet val$sourceSet;
                {
                    this.val$sourceSet = charSet;
                }

                public boolean accept(char key, int value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                CharIntHashMap.access$302(CharIntHashMap.this, retained.keys);
                CharIntHashMap.access$502(CharIntHashMap.this, retained.values);
                CharIntHashMap.this.sentinelValues = retained.sentinelValues;
                CharIntHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharIntHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll(CharHashSet.newSetWith(source));
        }

        public CharSet freeze() {
            CharIntHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (CharIntHashMap.this.sentinelValues != null) {
                containsZeroKey = ((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((CharIntHashMap)CharIntHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableCharMapKeySet(CharIntHashMap.this.keys, CharIntHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < CharIntHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharIntHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharIntHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return this.lastKey;
                }
            }
            char[] keys = CharIntHashMap.this.keys;
            while (!CharIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharIntHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyCharIterable {
        private KeysView() {
        }

        public CharIterator charIterator() {
            return new UnmodifiableCharIterator((CharIterator)new KeySetIterator());
        }

        public void forEach(CharProcedure procedure) {
            CharIntHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalIntIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return this.count < CharIntHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharIntHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return CharIntHashMap.this.get('\u0000');
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharIntHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return CharIntHashMap.this.get('\u0001');
                }
            }
            char[] keys = CharIntHashMap.this.keys;
            while (!CharIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            int result = CharIntHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharIntHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

