/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.impl.set.immutable.primitive.AbstractImmutableFloatSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableFloatSetSerializationProxy;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableFloatMapKeySet
extends AbstractImmutableFloatSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private final float[] keys;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableFloatMapKeySet(float[] keys, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keys = keys;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !ImmutableFloatMapKeySet.isEmptyKey(key) && !ImmutableFloatMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += Float.floatToIntBits(0.0f);
        }
        if (this.containsOneKey) {
            result += Float.floatToIntBits(1.0f);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                result += Float.floatToIntBits(this.keys[i]);
            }
        }
        return result;
    }

    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0.0f));
                ++count;
            }
            if (this.containsOneKey) {
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(1.0f));
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(this.keys[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public float[] toArray() {
        float[] array = new float[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0.0f;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1.0f;
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    public boolean contains(float value) {
        if (Float.compare(value, 0.0f) == 0) {
            return this.containsZeroKey;
        }
        if (Float.compare(value, 1.0f) == 0) {
            return this.containsOneKey;
        }
        return Float.compare(this.keys[this.probe(value)], value) == 0;
    }

    public void forEach(FloatProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value(0.0f);
        }
        if (this.containsOneKey) {
            procedure.value(1.0f);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                procedure.value(this.keys[i]);
            }
        }
    }

    public ImmutableFloatSet select(FloatPredicate predicate) {
        FloatHashSet result = new FloatHashSet();
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            result.add(0.0f);
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            result.add(1.0f);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    public ImmutableFloatSet reject(FloatPredicate predicate) {
        FloatHashSet result = new FloatHashSet();
        if (this.containsZeroKey && !predicate.accept(0.0f)) {
            result.add(0.0f);
        }
        if (this.containsOneKey && !predicate.accept(1.0f)) {
            result.add(1.0f);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf(0.0f));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf(1.0f));
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                target.add(function.valueOf(this.keys[i]));
            }
        }
        return target.toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return 0.0f;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return 1.0f;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return this.keys[i];
        }
        return ifNone;
    }

    public int count(FloatPredicate predicate) {
        int count = 0;
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            ++count;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            ++count;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept(0.0f)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept(1.0f)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public double sum() {
        double result = 0.0;
        if (this.containsZeroKey) {
            result += 0.0;
        }
        if (this.containsOneKey) {
            result += 1.0;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                result += (double)this.keys[i];
            }
        }
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float max = 0.0f;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max = 0.0f;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || Float.compare(max, 1.0f) < 0)) {
            max = 1.0f;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || isMaxSet && Float.compare(max, this.keys[i]) >= 0) continue;
            max = this.keys[i];
            isMaxSet = true;
        }
        return max;
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float min = 0.0f;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min = 0.0f;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1.0f < min)) {
            min = 1.0f;
            isMinSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || isMinSet && Float.compare(this.keys[i], min) >= 0) continue;
            min = this.keys[i];
            isMinSet = true;
        }
        return min;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, 0.0f);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, 1.0f);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                result = function.valueOf(result, this.keys[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableFloatSetSerializationProxy(this);
    }

    int probe(float element) {
        int index = this.spread(element);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Float.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Float.compare(this.keys[nextIndex], 1.0f) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Float.compare(this.keys[nextIndex], 0.0f) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(float element) {
        int code = Float.floatToIntBits(element);
        code ^= code >>> 15;
        code *= 1854960195;
        code ^= code >>> 13;
        code *= -75769267;
        code ^= code >>> 11;
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private class InternalFloatIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count < ImmutableFloatMapKeySet.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableFloatMapKeySet.this.containsZeroKey) {
                    return 0.0f;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableFloatMapKeySet.this.containsOneKey) {
                    return 1.0f;
                }
            }
            float[] keys = ImmutableFloatMapKeySet.this.keys;
            while (!ImmutableFloatMapKeySet.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = ImmutableFloatMapKeySet.this.keys[this.position];
            ++this.position;
            return result;
        }
    }
}

