/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.impl.set.immutable.primitive.AbstractImmutableIntSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableIntSetSerializationProxy;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableIntMapKeySet
extends AbstractImmutableIntSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private final int[] keys;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableIntMapKeySet(int[] keys, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keys = keys;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !ImmutableIntMapKeySet.isEmptyKey(key) && !ImmutableIntMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += 0;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i])) continue;
                result += this.keys[i];
            }
        }
        return result;
    }

    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0));
                ++count;
            }
            if (this.containsOneKey) {
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(1));
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i])) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(this.keys[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    public int[] toArray() {
        int[] array = new int[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1;
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    public boolean contains(int value) {
        if (value == 0) {
            return this.containsZeroKey;
        }
        if (value == 1) {
            return this.containsOneKey;
        }
        return this.keys[this.probe(value)] == value;
    }

    public void forEach(IntProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value(0);
        }
        if (this.containsOneKey) {
            procedure.value(1);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i])) continue;
                procedure.value(this.keys[i]);
            }
        }
    }

    public ImmutableIntSet select(IntPredicate predicate) {
        IntHashSet result = new IntHashSet();
        if (this.containsZeroKey && predicate.accept(0)) {
            result.add(0);
        }
        if (this.containsOneKey && predicate.accept(1)) {
            result.add(1);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    public ImmutableIntSet reject(IntPredicate predicate) {
        IntHashSet result = new IntHashSet();
        if (this.containsZeroKey && !predicate.accept(0)) {
            result.add(0);
        }
        if (this.containsOneKey && !predicate.accept(1)) {
            result.add(1);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf(0));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf(1));
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i])) continue;
                target.add(function.valueOf(this.keys[i]));
            }
        }
        return target.toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        if (this.containsZeroKey && predicate.accept(0)) {
            return 0;
        }
        if (this.containsOneKey && predicate.accept(1)) {
            return 1;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return this.keys[i];
        }
        return ifNone;
    }

    public int count(IntPredicate predicate) {
        int count = 0;
        if (this.containsZeroKey && predicate.accept(0)) {
            ++count;
        }
        if (this.containsOneKey && predicate.accept(1)) {
            ++count;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept(1)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept(0)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept(1)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept(1)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public long sum() {
        long result = 0L;
        if (this.containsZeroKey) {
            result += 0L;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i])) continue;
                result += (long)this.keys[i];
            }
        }
        return result;
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int max = 0;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max = 0;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || max < 1)) {
            max = 1;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.keys[i]) continue;
            max = this.keys[i];
            isMaxSet = true;
        }
        return max;
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int min = 0;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min = 0;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1 < min)) {
            min = 1;
            isMinSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i]) || isMinSet && this.keys[i] >= min) continue;
            min = this.keys[i];
            isMinSet = true;
        }
        return min;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, 0);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, 1);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableIntMapKeySet.isNonSentinel(this.keys[i])) continue;
                result = function.valueOf(result, this.keys[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableIntSetSerializationProxy(this);
    }

    int probe(int element) {
        int index = this.spread(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(int element) {
        int code = element;
        code ^= code >>> 15;
        code *= 1854960195;
        code ^= code >>> 13;
        code *= -75769267;
        code ^= code >>> 11;
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private class InternalIntIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return this.count < ImmutableIntMapKeySet.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableIntMapKeySet.this.containsZeroKey) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableIntMapKeySet.this.containsOneKey) {
                    return 1;
                }
            }
            int[] keys = ImmutableIntMapKeySet.this.keys;
            while (!ImmutableIntMapKeySet.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = ImmutableIntMapKeySet.this.keys[this.position];
            ++this.position;
            return result;
        }
    }
}

