/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToByteFunction;
import com.gs.collections.api.block.predicate.primitive.ShortBytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.MutableByteIterator;
import com.gs.collections.api.iterator.MutableShortIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.map.primitive.ImmutableShortByteMap;
import com.gs.collections.api.map.primitive.MutableShortByteMap;
import com.gs.collections.api.map.primitive.ShortByteMap;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.api.tuple.primitive.ShortBytePair;
import com.gs.collections.impl.factory.primitive.ShortByteMaps;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableByteValuesMap;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableShortKeySet;
import com.gs.collections.impl.map.mutable.primitive.ImmutableShortMapKeySet;
import com.gs.collections.impl.map.mutable.primitive.MutableShortKeysMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedShortByteMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableShortByteMap;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortByteHashMap
extends AbstractMutableByteValuesMap
implements MutableShortByteMap,
Externalizable,
MutableShortKeysMap {
    private static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private short[] keys;
    private byte[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableByteValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public ShortByteHashMap() {
        this.allocateTable(16);
    }

    public ShortByteHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public ShortByteHashMap(ShortByteMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static ShortByteHashMap newWithKeysValues(short key1, byte value1) {
        return new ShortByteHashMap(1).withKeyValue(key1, value1);
    }

    public static ShortByteHashMap newWithKeysValues(short key1, byte value1, short key2, byte value2) {
        return new ShortByteHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ShortByteHashMap newWithKeysValues(short key1, byte value1, short key2, byte value2, short key3, byte value3) {
        return new ShortByteHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ShortByteHashMap newWithKeysValues(short key1, byte value1, short key2, byte value2, short key3, byte value3, short key4, byte value4) {
        return new ShortByteHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableByteValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected byte getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected byte getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortByteMap)) {
            return false;
        }
        ShortByteMap other = (ShortByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((short)0) || other.containsKey((short)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((short)0) || this.sentinelValues.zeroValue != other.getOrThrow((short)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((short)1) || this.sentinelValues.oneValue != other.getOrThrow((short)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortByteHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortByteHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortByteHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, (byte)0);
    }

    public void put(short key, byte value) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(byte value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(byte value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(ShortByteMap map) {
        map.forEachKeyValue(new ShortByteProcedure(){

            public void value(short key, byte value) {
                ShortByteHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(short key) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(short key) {
        this.removeKey(key);
    }

    public byte removeKeyIfAbsent(short key, byte value) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            byte oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public byte getIfAbsentPut(short key, byte value) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte getIfAbsentPut(short key, ByteFunction0 function) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> byte getIfAbsentPutWith(short key, ByteFunction<? super P> function, P parameter) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.byteValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte getIfAbsentPutWithKey(short key, ShortToByteFunction function) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte addToValue(short key, byte toBeAdded) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (byte)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (byte)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (byte)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(short key, byte value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
        if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
            this.rehash();
        }
    }

    private void copyKeys() {
        short[] copy = new short[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public byte updateValue(short key, byte initialValueIfAbsent, ByteToByteFunction function) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        byte value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public ShortByteHashMap withKeyValue(short key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public ShortByteHashMap withKeysValues(short key1, byte value1, short key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ShortByteHashMap withKeysValues(short key1, byte value1, short key2, byte value2, short key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ShortByteHashMap withKeysValues(short key1, byte value1, short key2, byte value2, short key3, byte value3, short key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ShortByteHashMap withoutKey(short key) {
        this.removeKey(key);
        return this;
    }

    public ShortByteHashMap withoutAllKeys(ShortIterable keys) {
        keys.forEach(new ShortProcedure(){

            public void value(short key) {
                ShortByteHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableShortByteMap asUnmodifiable() {
        return new UnmodifiableShortByteMap(this);
    }

    public MutableShortByteMap asSynchronized() {
        return new SynchronizedShortByteMap(this);
    }

    public ImmutableShortByteMap toImmutable() {
        return ShortByteMaps.immutable.ofAll((ShortByteMap)this);
    }

    public byte get(short key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(short key, byte ifAbsent) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public byte getOrThrow(short key) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ShortByteHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(short key) {
        if (ShortByteHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ShortByteHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(ShortByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyShortIterable keysView() {
        return new KeysView();
    }

    public RichIterable<ShortBytePair> keyValuesView() {
        return new KeyValuesView();
    }

    public ShortByteHashMap select(ShortBytePredicate predicate) {
        ShortByteHashMap result = new ShortByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ShortByteHashMap reject(ShortBytePredicate predicate) {
        ShortByteHashMap result = new ShortByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeShort(0);
                out.writeByte(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeShort(1);
                out.writeByte(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortByteHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeShort(this.keys[i]);
            out.writeByte(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readShort(), in.readByte());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        short[] old = this.keys;
        byte[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortByteHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(short element) {
        int index = this.spread(element);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(short element) {
        int code = element;
        code ^= code >>> 15;
        code *= 1854960195;
        code ^= code >>> 13;
        code *= -75769267;
        code ^= code >>> 11;
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new short[sizeToAllocate];
        this.values = new byte[sizeToAllocate];
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ShortByteHashMap.isEmptyKey(key) && !ShortByteHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !ShortByteHashMap.isEmptyKey(this.keys[index]) && !ShortByteHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    public MutableShortSet keySet() {
        return new KeySet();
    }

    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ short[] access$302(ShortByteHashMap x0, short[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(ShortByteHashMap x0, byte[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ShortBytePair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ShortBytePair> procedure) {
            if (ShortByteHashMap.this.sentinelValues != null) {
                if (((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)0, ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.zeroValue));
                }
                if (((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)1, ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ShortByteHashMap.this.keys.length; ++i) {
                if (!ShortByteHashMap.isNonSentinel(ShortByteHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ShortByteHashMap.this.keys[i], ShortByteHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ShortBytePair> objectIntProcedure) {
            int index = 0;
            if (ShortByteHashMap.this.sentinelValues != null) {
                if (((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((short)0, ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((short)1, ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ShortByteHashMap.this.keys.length; ++i) {
                if (!ShortByteHashMap.isNonSentinel(ShortByteHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(ShortByteHashMap.this.keys[i], ShortByteHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ShortBytePair, ? super P> procedure, P parameter) {
            if (ShortByteHashMap.this.sentinelValues != null) {
                if (((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)0, ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)1, ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ShortByteHashMap.this.keys.length; ++i) {
                if (!ShortByteHashMap.isNonSentinel(ShortByteHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ShortByteHashMap.this.keys[i], ShortByteHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ShortBytePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ShortBytePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ShortBytePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ShortByteHashMap.this.containsKey((short)0)) {
                        return PrimitiveTuples.pair((short)0, ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ShortByteHashMap.this.containsKey((short)1)) {
                        return PrimitiveTuples.pair((short)1, ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.oneValue);
                    }
                }
                short[] keys = ShortByteHashMap.this.keys;
                while (!ShortByteHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ShortBytePair result = PrimitiveTuples.pair(keys[this.position], ShortByteHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ShortByteHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableByteValuesMap.AbstractByteValuesCollection {
        private ValuesCollection() {
        }

        public MutableByteIterator byteIterator() {
            return ShortByteHashMap.this.byteIterator();
        }

        public boolean remove(byte item) {
            int oldSize = ShortByteHashMap.this.size();
            if (ShortByteHashMap.this.sentinelValues != null) {
                if (((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsZeroKey && item == ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.zeroValue) {
                    ShortByteHashMap.this.removeKey((short)0);
                }
                if (((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsOneKey && item == ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.oneValue) {
                    ShortByteHashMap.this.removeKey((short)1);
                }
            }
            for (int i = 0; i < ShortByteHashMap.this.keys.length; ++i) {
                if (!ShortByteHashMap.isNonSentinel(ShortByteHashMap.this.keys[i]) || item != ShortByteHashMap.this.values[i]) continue;
                ShortByteHashMap.this.removeKey(ShortByteHashMap.this.keys[i]);
            }
            return oldSize != ShortByteHashMap.this.size();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = ShortByteHashMap.this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            ShortByteHashMap retained = ShortByteHashMap.this.select(new ShortBytePredicate((ByteSet)sourceSet){
                final /* synthetic */ ByteSet val$sourceSet;
                {
                    this.val$sourceSet = byteSet;
                }

                public boolean accept(short key, byte value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                ShortByteHashMap.access$302(ShortByteHashMap.this, retained.keys);
                ShortByteHashMap.access$502(ShortByteHashMap.this, retained.values);
                ShortByteHashMap.this.sentinelValues = retained.sentinelValues;
                ShortByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableShortKeySet {
        private KeySet() {
        }

        protected MutableShortKeysMap getOuter() {
            return ShortByteHashMap.this;
        }

        protected AbstractMutableByteValuesMap.SentinelValues getSentinelValues() {
            return ShortByteHashMap.this.sentinelValues;
        }

        protected short getKeyAtIndex(int index) {
            return ShortByteHashMap.this.keys[index];
        }

        protected int getTableSize() {
            return ShortByteHashMap.this.keys.length;
        }

        public MutableShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = ShortByteHashMap.this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            ShortByteHashMap retained = ShortByteHashMap.this.select(new ShortBytePredicate((ShortSet)sourceSet){
                final /* synthetic */ ShortSet val$sourceSet;
                {
                    this.val$sourceSet = shortSet;
                }

                public boolean accept(short key, byte value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                ShortByteHashMap.access$302(ShortByteHashMap.this, retained.keys);
                ShortByteHashMap.access$502(ShortByteHashMap.this, retained.values);
                ShortByteHashMap.this.sentinelValues = retained.sentinelValues;
                ShortByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(short ... source) {
            return this.retainAll(ShortHashSet.newSetWith(source));
        }

        public ShortSet freeze() {
            ShortByteHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (ShortByteHashMap.this.sentinelValues != null) {
                containsZeroKey = ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((ShortByteHashMap)ShortByteHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableShortMapKeySet(ShortByteHashMap.this.keys, ShortByteHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private short lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortByteHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortByteHashMap.this.containsKey((short)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortByteHashMap.this.containsKey((short)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            short[] keys = ShortByteHashMap.this.keys;
            while (!ShortByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ShortByteHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyShortIterable {
        private KeysView() {
        }

        public ShortIterator shortIterator() {
            return new UnmodifiableShortIterator((ShortIterator)new KeySetIterator());
        }

        public void forEach(ShortProcedure procedure) {
            ShortByteHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalByteIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private short lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalByteIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortByteHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortByteHashMap.this.containsKey((short)0)) {
                    this.lastKey = 0;
                    return ShortByteHashMap.this.get((short)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortByteHashMap.this.containsKey((short)1)) {
                    this.lastKey = 1;
                    return ShortByteHashMap.this.get((short)1);
                }
            }
            short[] keys = ShortByteHashMap.this.keys;
            while (!ShortByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            byte result = ShortByteHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ShortByteHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

