/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectBooleanPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectBooleanProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.MutableBooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ImmutableObjectBooleanMap;
import com.gs.collections.api.map.primitive.MutableObjectBooleanMap;
import com.gs.collections.api.map.primitive.ObjectBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.tuple.primitive.ObjectBooleanPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.factory.primitive.ObjectBooleanMaps;
import com.gs.collections.impl.iterator.UnmodifiableBooleanIterator;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedObjectBooleanMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableObjectBooleanMap<K>
implements MutableObjectBooleanMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectBooleanMap<K> map;

    UnmodifiableObjectBooleanMap(MutableObjectBooleanMap<K> map) {
        this.map = map;
    }

    private boolean isAbsent(boolean result, K key) {
        return !result && !this.containsKey(key);
    }

    private boolean getIfAbsentThrow(K key) {
        boolean result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, boolean value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectBooleanMap<? extends K> map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeKeyIfAbsent(K key, boolean value) {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public boolean getIfAbsentPut(K key, boolean value) {
        return this.getIfAbsentThrow(key);
    }

    public boolean getIfAbsentPut(K key, BooleanFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public boolean getIfAbsentPutWithKey(K key, BooleanFunction<? super K> function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> boolean getIfAbsentPutWith(K key, BooleanFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public boolean updateValue(K key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public boolean addToValue(K key, boolean toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public boolean get(Object key) {
        return this.map.get(key);
    }

    public boolean getOrThrow(Object key) {
        return this.map.getOrThrow(key);
    }

    public boolean getIfAbsent(Object key, boolean ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(boolean value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectBooleanProcedure<? super K> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectBooleanMap<K> select(ObjectBooleanPredicate<? super K> predicate) {
        return this.map.select(predicate);
    }

    public MutableObjectBooleanMap<K> reject(ObjectBooleanPredicate<? super K> predicate) {
        return this.map.reject(predicate);
    }

    public MutableBooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator((BooleanIterator)this.map.booleanIterator());
    }

    public void forEach(BooleanProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(BooleanPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableBooleanCollection select(BooleanPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        return this.map.reject(predicate);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(BooleanToObjectFunction<? extends V1> function) {
        return this.map.collect(function);
    }

    public boolean[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(boolean value) {
        return this.map.contains(value);
    }

    public boolean containsAll(boolean ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source) {
        return this.map.containsAll(source);
    }

    public MutableBooleanList toList() {
        return this.map.toList();
    }

    public MutableBooleanSet toSet() {
        return this.map.toSet();
    }

    public MutableBooleanBag toBag() {
        return this.map.toBag();
    }

    public LazyBooleanIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableObjectBooleanMap<K> withKeyValue(K key, boolean value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectBooleanMap<K> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectBooleanMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectBooleanMap<K> asUnmodifiable() {
        return this;
    }

    public MutableObjectBooleanMap<K> asSynchronized() {
        return new SynchronizedObjectBooleanMap(this);
    }

    public ImmutableObjectBooleanMap<K> toImmutable() {
        return ObjectBooleanMaps.immutable.withAll((ObjectBooleanMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableBooleanCollection values() {
        return UnmodifiableBooleanCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView() {
        return this.map.keysView();
    }

    public RichIterable<ObjectBooleanPair<K>> keyValuesView() {
        return this.map.keyValuesView();
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

