/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;
import com.gs.collections.api.stack.primitive.MutableShortStack;
import com.gs.collections.impl.factory.primitive.ShortStacks;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedShortStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableShortStack
implements MutableShortStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortStack stack;

    UnmodifiableShortStack(MutableShortStack stack) {
        this.stack = stack;
    }

    public void push(short item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public short pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public ShortList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public short peek() {
        return this.stack.peek();
    }

    public ShortList peek(int count) {
        return this.stack.peek(count);
    }

    public short peekAt(int index) {
        return this.stack.peekAt(index);
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(short value) {
        return this.stack.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.stack.containsAll(source);
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.stack.shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.stack.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableShortStack select(ShortPredicate predicate) {
        return this.stack.select(predicate);
    }

    public MutableShortStack reject(ShortPredicate predicate) {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    public long sum() {
        return this.stack.sum();
    }

    public short max() {
        return this.stack.max();
    }

    public short min() {
        return this.stack.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    public short maxIfEmpty(short defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.stack.average();
    }

    public double median() {
        return this.stack.median();
    }

    public MutableShortList toSortedList() {
        return this.stack.toSortedList();
    }

    public short[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    public short[] toArray() {
        return this.stack.toArray();
    }

    public String toString() {
        return this.stack.toString();
    }

    public String makeString() {
        return this.stack.makeString();
    }

    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableShortList toList() {
        return this.stack.toList();
    }

    public MutableShortSet toSet() {
        return this.stack.toSet();
    }

    public MutableShortBag toBag() {
        return this.stack.toBag();
    }

    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    public int hashCode() {
        return this.stack.hashCode();
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public MutableShortStack asUnmodifiable() {
        return this;
    }

    public MutableShortStack asSynchronized() {
        return new SynchronizedShortStack(this);
    }

    public ImmutableShortStack toImmutable() {
        return ShortStacks.immutable.withAllReversed((ShortIterable)this);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)this.stack.injectInto(injectedValue, function);
    }
}

