/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.utility.ArrayIterate;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.ListIterate;
import com.gs.collections.impl.utility.internal.InternalArrayIterate;
import com.gs.collections.impl.utility.internal.RandomAccessListIterate;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayListIterate {
    private static final Field ELEMENT_DATA_FIELD;
    private static final Field SIZE_FIELD;
    private static final int MIN_DIRECT_ARRAY_ACCESS_SIZE = 100;

    private ArrayListIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> ArrayList<T> select(ArrayList<T> list, Predicate<? super T> predicate) {
        return ArrayListIterate.select(list, predicate, new ArrayList());
    }

    public static <T, IV> ArrayList<T> selectWith(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        return ArrayListIterate.selectWith(list, predicate, injectedValue, new ArrayList());
    }

    public static <T, R extends Collection<T>> R select(ArrayList<T> list, Predicate<? super T> predicate, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.select(list, predicate, targetCollection);
    }

    public static <T, P, R extends Collection<T>> R selectWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], parameter)) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.selectWith(list, predicate, parameter, targetCollection);
    }

    public static <T> MutableList<T> selectInstancesOf(ArrayList<?> list, Class<T> clazz) {
        int size = list.size();
        FastList result = FastList.newList(size);
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            ?[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                Object element = elements[i];
                if (!clazz.isInstance(element)) continue;
                result.add(element);
            }
            result.trimToSize();
            return result;
        }
        return RandomAccessListIterate.selectInstancesOf(list, clazz);
    }

    public static <T> int count(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            int count = 0;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                ++count;
            }
            return count;
        }
        return RandomAccessListIterate.count(list, predicate);
    }

    public static <T, P> int countWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            int count = 0;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], parameter)) continue;
                ++count;
            }
            return count;
        }
        return RandomAccessListIterate.countWith(list, predicate, parameter);
    }

    public static <T, A> ArrayList<A> collectIf(ArrayList<T> list, Predicate<? super T> predicate, Function<? super T, ? extends A> function) {
        return ArrayListIterate.collectIf(list, predicate, function, new ArrayList());
    }

    public static <T, A, R extends Collection<A>> R collectIf(ArrayList<T> list, Predicate<? super T> predicate, Function<? super T, ? extends A> function, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                targetCollection.add((Object)function.valueOf(elements[i]));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.collectIf(list, predicate, function, targetCollection);
    }

    public static <T> ArrayList<T> reject(ArrayList<T> list, Predicate<? super T> predicate) {
        return ArrayListIterate.reject(list, predicate, new ArrayList());
    }

    public static <T, IV> ArrayList<T> rejectWith(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        return ArrayListIterate.rejectWith(list, predicate, injectedValue, new ArrayList());
    }

    public static <T, R extends Collection<T>> R reject(ArrayList<T> list, Predicate<? super T> predicate, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i])) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.reject(list, predicate, targetCollection);
    }

    public static <T, P, R extends Collection<T>> R rejectWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P injectedValue, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i], injectedValue)) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.rejectWith(list, predicate, injectedValue, targetCollection);
    }

    public static <T, A> ArrayList<A> collect(ArrayList<T> list, Function<? super T, ? extends A> function) {
        return ArrayListIterate.collect(list, function, new ArrayList(list.size()));
    }

    public static <T> MutableBooleanList collectBoolean(ArrayList<T> list, BooleanFunction<? super T> booleanFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            BooleanArrayList result = new BooleanArrayList(size);
            return ArrayListIterate.collectBooleanFromInternalArray(list, booleanFunction, size, result);
        }
        return RandomAccessListIterate.collectBoolean(list, booleanFunction);
    }

    public static <T, R extends MutableBooleanCollection> R collectBoolean(ArrayList<T> list, BooleanFunction<? super T> booleanFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectBooleanFromInternalArray(list, booleanFunction, size, target);
        }
        return RandomAccessListIterate.collectBoolean(list, booleanFunction, target);
    }

    private static <T, R extends MutableBooleanCollection> R collectBooleanFromInternalArray(ArrayList<T> source, BooleanFunction<? super T> booleanFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(booleanFunction.booleanValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableByteList collectByte(ArrayList<T> list, ByteFunction<? super T> byteFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            ByteArrayList result = new ByteArrayList(size);
            return ArrayListIterate.collectByteFromInternalArray(list, byteFunction, size, result);
        }
        return RandomAccessListIterate.collectByte(list, byteFunction);
    }

    public static <T, R extends MutableByteCollection> R collectByte(ArrayList<T> list, ByteFunction<? super T> byteFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectByteFromInternalArray(list, byteFunction, size, target);
        }
        return RandomAccessListIterate.collectByte(list, byteFunction, target);
    }

    private static <T, R extends MutableByteCollection> R collectByteFromInternalArray(ArrayList<T> source, ByteFunction<? super T> byteFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(byteFunction.byteValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableCharList collectChar(ArrayList<T> list, CharFunction<? super T> charFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            CharArrayList result = new CharArrayList(size);
            return ArrayListIterate.collectCharFromInternalArray(list, charFunction, size, result);
        }
        return RandomAccessListIterate.collectChar(list, charFunction);
    }

    public static <T, R extends MutableCharCollection> R collectChar(ArrayList<T> list, CharFunction<? super T> charFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectCharFromInternalArray(list, charFunction, size, target);
        }
        return RandomAccessListIterate.collectChar(list, charFunction, target);
    }

    private static <T, R extends MutableCharCollection> R collectCharFromInternalArray(ArrayList<T> source, CharFunction<? super T> charFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(charFunction.charValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableDoubleList collectDouble(ArrayList<T> list, DoubleFunction<? super T> doubleFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            DoubleArrayList result = new DoubleArrayList(size);
            return ArrayListIterate.collectDoubleFromInternalArray(list, doubleFunction, size, result);
        }
        return RandomAccessListIterate.collectDouble(list, doubleFunction);
    }

    public static <T, R extends MutableDoubleCollection> R collectDouble(ArrayList<T> list, DoubleFunction<? super T> doubleFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectDoubleFromInternalArray(list, doubleFunction, size, target);
        }
        return RandomAccessListIterate.collectDouble(list, doubleFunction, target);
    }

    private static <T, R extends MutableDoubleCollection> R collectDoubleFromInternalArray(ArrayList<T> source, DoubleFunction<? super T> doubleFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(doubleFunction.doubleValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableFloatList collectFloat(ArrayList<T> list, FloatFunction<? super T> floatFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            FloatArrayList result = new FloatArrayList(size);
            return ArrayListIterate.collectFloatFromInternalArray(list, floatFunction, size, result);
        }
        return RandomAccessListIterate.collectFloat(list, floatFunction);
    }

    public static <T, R extends MutableFloatCollection> R collectFloat(ArrayList<T> list, FloatFunction<? super T> floatFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectFloatFromInternalArray(list, floatFunction, size, target);
        }
        return RandomAccessListIterate.collectFloat(list, floatFunction, target);
    }

    private static <T, R extends MutableFloatCollection> R collectFloatFromInternalArray(ArrayList<T> source, FloatFunction<? super T> floatFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(floatFunction.floatValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableIntList collectInt(ArrayList<T> list, IntFunction<? super T> intFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            IntArrayList result = new IntArrayList(size);
            return ArrayListIterate.collectIntFromInternalArray(list, intFunction, size, result);
        }
        return RandomAccessListIterate.collectInt(list, intFunction);
    }

    public static <T, R extends MutableIntCollection> R collectInt(ArrayList<T> list, IntFunction<? super T> intFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectIntFromInternalArray(list, intFunction, size, target);
        }
        return RandomAccessListIterate.collectInt(list, intFunction, target);
    }

    private static <T, R extends MutableIntCollection> R collectIntFromInternalArray(ArrayList<T> source, IntFunction<? super T> intFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(intFunction.intValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableLongList collectLong(ArrayList<T> list, LongFunction<? super T> longFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            LongArrayList result = new LongArrayList(size);
            return ArrayListIterate.collectLongFromInternalArray(list, longFunction, size, result);
        }
        return RandomAccessListIterate.collectLong(list, longFunction);
    }

    public static <T, R extends MutableLongCollection> R collectLong(ArrayList<T> list, LongFunction<? super T> longFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectLongFromInternalArray(list, longFunction, size, target);
        }
        return RandomAccessListIterate.collectLong(list, longFunction, target);
    }

    private static <T, R extends MutableLongCollection> R collectLongFromInternalArray(ArrayList<T> source, LongFunction<? super T> longFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(longFunction.longValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableShortList collectShort(ArrayList<T> list, ShortFunction<? super T> shortFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            ShortArrayList result = new ShortArrayList(size);
            return ArrayListIterate.collectShortFromInternalArray(list, shortFunction, size, result);
        }
        return RandomAccessListIterate.collectShort(list, shortFunction);
    }

    public static <T, R extends MutableShortCollection> R collectShort(ArrayList<T> list, ShortFunction<? super T> shortFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectShortFromInternalArray(list, shortFunction, size, target);
        }
        return RandomAccessListIterate.collectShort(list, shortFunction, target);
    }

    private static <T, R extends MutableShortCollection> R collectShortFromInternalArray(ArrayList<T> source, ShortFunction<? super T> shortFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(shortFunction.shortValueOf(elements[i]));
        }
        return target;
    }

    public static <T, A, R extends Collection<A>> R collect(ArrayList<T> list, Function<? super T, ? extends A> function, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                targetCollection.add((Object)function.valueOf(elements[i]));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.collect(list, function, targetCollection);
    }

    public static <T, A> ArrayList<A> flatCollect(ArrayList<T> list, Function<? super T, ? extends Iterable<A>> function) {
        return ArrayListIterate.flatCollect(list, function, new ArrayList(list.size()));
    }

    public static <T, A, R extends Collection<A>> R flatCollect(ArrayList<T> list, Function<? super T, ? extends Iterable<A>> function, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                Iterate.addAllTo((Iterable)function.valueOf(elements[i]), targetCollection);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.flatCollect(list, function, targetCollection);
    }

    public static <T> void forEach(ArrayList<T> list, Procedure<? super T> procedure) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                procedure.value(elements[i]);
            }
        } else {
            RandomAccessListIterate.forEach(list, procedure);
        }
    }

    public static <T> void reverseForEach(ArrayList<T> list, Procedure<? super T> procedure) {
        if (!list.isEmpty()) {
            ArrayListIterate.forEach(list, list.size() - 1, 0, procedure);
        }
    }

    public static <T> void forEach(ArrayList<T> list, int from, int to, Procedure<? super T> procedure) {
        ListIterate.rangeCheck(from, to, list.size());
        if (ArrayListIterate.isOptimizableArrayList(list, to - from + 1)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            InternalArrayIterate.forEachWithoutChecks(elements, from, to, procedure);
        } else {
            RandomAccessListIterate.forEach(list, from, to, procedure);
        }
    }

    public static <T> void forEachWithIndex(ArrayList<T> list, int from, int to, ObjectIntProcedure<? super T> objectIntProcedure) {
        ListIterate.rangeCheck(from, to, list.size());
        if (ArrayListIterate.isOptimizableArrayList(list, to - from + 1)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            InternalArrayIterate.forEachWithIndexWithoutChecks(elements, from, to, objectIntProcedure);
        } else {
            RandomAccessListIterate.forEachWithIndex(list, from, to, objectIntProcedure);
        }
    }

    public static <T1, T2> void forEachInBoth(ArrayList<T1> list1, ArrayList<T2> list2, Procedure2<? super T1, ? super T2> procedure) {
        RandomAccessListIterate.forEachInBoth(list1, list2, procedure);
    }

    public static <T> void forEachWithIndex(ArrayList<T> list, ObjectIntProcedure<? super T> objectIntProcedure) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                objectIntProcedure.value(elements[i], i);
            }
        } else {
            RandomAccessListIterate.forEachWithIndex(list, objectIntProcedure);
        }
    }

    public static <T> T detect(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T item = elements[i];
                if (!predicate.accept(item)) continue;
                return item;
            }
            return null;
        }
        return RandomAccessListIterate.detect(list, predicate);
    }

    public static <T, P> T detectWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T item = elements[i];
                if (!predicate.accept(item, parameter)) continue;
                return item;
            }
            return null;
        }
        return RandomAccessListIterate.detectWith(list, predicate, parameter);
    }

    public static <T> T detectIfNone(ArrayList<T> list, Predicate<? super T> predicate, T ifNone) {
        T result = ArrayListIterate.detect(list, predicate);
        return result == null ? ifNone : result;
    }

    public static <T, IV> T detectWithIfNone(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue, T ifNone) {
        T result = ArrayListIterate.detectWith(list, predicate, injectedValue);
        return result == null ? ifNone : result;
    }

    public static <T, IV> IV injectInto(IV injectValue, ArrayList<T> list, Function2<? super IV, ? super T, ? extends IV> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            Object result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.value(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> int injectInto(int injectValue, ArrayList<T> list, IntObjectToIntFunction<? super T> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            int result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.intValueOf(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> long injectInto(long injectValue, ArrayList<T> list, LongObjectToLongFunction<? super T> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            long result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.longValueOf(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> double injectInto(double injectValue, ArrayList<T> list, DoubleObjectToDoubleFunction<? super T> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            double result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.doubleValueOf(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> float injectInto(float injectValue, ArrayList<T> list, FloatObjectToFloatFunction<? super T> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            float result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.floatValueOf(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> boolean anySatisfy(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                return true;
            }
            return false;
        }
        return RandomAccessListIterate.anySatisfy(list, predicate);
    }

    public static <T, P> boolean anySatisfyWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], parameter)) continue;
                return true;
            }
            return false;
        }
        return RandomAccessListIterate.anySatisfyWith(list, predicate, parameter);
    }

    public static <T> boolean allSatisfy(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i])) continue;
                return false;
            }
            return true;
        }
        return RandomAccessListIterate.allSatisfy(list, predicate);
    }

    public static <T, IV> boolean allSatisfyWith(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i], injectedValue)) continue;
                return false;
            }
            return true;
        }
        return RandomAccessListIterate.allSatisfyWith(list, predicate, injectedValue);
    }

    public static <T> boolean noneSatisfy(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                return false;
            }
            return true;
        }
        return RandomAccessListIterate.noneSatisfy(list, predicate);
    }

    public static <T, IV> boolean noneSatisfyWith(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], injectedValue)) continue;
                return false;
            }
            return true;
        }
        return RandomAccessListIterate.noneSatisfyWith(list, predicate, injectedValue);
    }

    public static <T, P> Twin<MutableList<T>> selectAndRejectWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            MutableList positiveResult = Lists.mutable.empty();
            MutableList negativeResult = Lists.mutable.empty();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                (predicate.accept(elements[i], parameter) ? positiveResult : negativeResult).add(elements[i]);
            }
            return Tuples.twin(positiveResult, negativeResult);
        }
        return RandomAccessListIterate.selectAndRejectWith(list, predicate, parameter);
    }

    public static <T> PartitionMutableList<T> partition(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            PartitionFastList partitionFastList = new PartitionFastList();
            MutableList selected = partitionFastList.getSelected();
            MutableList rejected = partitionFastList.getRejected();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T each = elements[i];
                MutableList bucket = predicate.accept(each) ? selected : rejected;
                bucket.add(each);
            }
            return partitionFastList;
        }
        return RandomAccessListIterate.partition(list, predicate);
    }

    public static <T, P> PartitionMutableList<T> partitionWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            PartitionFastList partitionFastList = new PartitionFastList();
            MutableList selected = partitionFastList.getSelected();
            MutableList rejected = partitionFastList.getRejected();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T each = elements[i];
                MutableList bucket = predicate.accept(each, parameter) ? selected : rejected;
                bucket.add(each);
            }
            return partitionFastList;
        }
        return RandomAccessListIterate.partitionWith(list, predicate, parameter);
    }

    public static <T> int detectIndex(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                return i;
            }
            return -1;
        }
        return RandomAccessListIterate.detectIndex(list, predicate);
    }

    public static <T, P> int detectIndexWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], parameter)) continue;
                return i;
            }
            return -1;
        }
        return RandomAccessListIterate.detectIndexWith(list, predicate, parameter);
    }

    public static <T> int detectLastIndex(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = size - 1; i >= 0; --i) {
                if (!predicate.accept(elements[i])) continue;
                return i;
            }
            return -1;
        }
        return RandomAccessListIterate.detectLastIndex(list, predicate);
    }

    public static <T, IV, P> IV injectIntoWith(IV injectedValue, ArrayList<T> list, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            Object result = injectedValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.value(result, elements[i], parameter);
            }
            return result;
        }
        return RandomAccessListIterate.injectIntoWith(injectedValue, list, function, parameter);
    }

    public static <T, P> void forEachWith(ArrayList<T> list, Procedure2<? super T, ? super P> procedure, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                procedure.value(elements[i], parameter);
            }
        } else {
            RandomAccessListIterate.forEachWith(list, procedure, parameter);
        }
    }

    public static <T, P, A> ArrayList<A> collectWith(ArrayList<T> list, Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return ArrayListIterate.collectWith(list, function, parameter, new ArrayList(list.size()));
    }

    public static <T, P, A, R extends Collection<A>> R collectWith(ArrayList<T> list, Function2<? super T, ? super P, ? extends A> function, P parameter, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                targetCollection.add((Object)function.value(elements[i], parameter));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.collectWith(list, function, parameter, targetCollection);
    }

    public static <T> ArrayList<T> removeIf(ArrayList<T> list, Predicate<? super T> predicate) {
        if (list.getClass() == ArrayList.class && SIZE_FIELD != null) {
            int currentFilledIndex = 0;
            int size = list.size();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i])) continue;
                if (currentFilledIndex != i) {
                    elements[currentFilledIndex] = elements[i];
                }
                ++currentFilledIndex;
            }
            ArrayListIterate.wipeAndResetTheEnd(currentFilledIndex, size, elements, list);
        } else {
            RandomAccessListIterate.removeIf(list, predicate);
        }
        return list;
    }

    public static <T, P> ArrayList<T> removeIfWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (list.getClass() == ArrayList.class && SIZE_FIELD != null) {
            int currentFilledIndex = 0;
            int size = list.size();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i], parameter)) continue;
                if (currentFilledIndex != i) {
                    elements[currentFilledIndex] = elements[i];
                }
                ++currentFilledIndex;
            }
            ArrayListIterate.wipeAndResetTheEnd(currentFilledIndex, size, elements, list);
        } else {
            RandomAccessListIterate.removeIfWith(list, predicate, parameter);
        }
        return list;
    }

    public static <T> ArrayList<T> distinct(ArrayList<T> list) {
        return ArrayListIterate.distinct(list, new ArrayList());
    }

    public static <T, R extends Collection<T>> R distinct(ArrayList<T> list, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            UnifiedSet seenSoFar = UnifiedSet.newSet();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!seenSoFar.add(elements[i])) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.distinct(list, targetCollection);
    }

    private static <T> void wipeAndResetTheEnd(int newCurrentFilledIndex, int newSize, T[] newElements, ArrayList<T> list) {
        for (int i = newCurrentFilledIndex; i < newSize; ++i) {
            newElements[i] = null;
        }
        try {
            SIZE_FIELD.setInt(list, newCurrentFilledIndex);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Something really bad happened on the way to pounding size into the ArrayList reflectively", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static <T extends Comparable<? super T>> ArrayList<T> sortThis(ArrayList<T> list) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> ArrayList<T> sortThis(ArrayList<T> list, Comparator<? super T> comparator) {
        int size = list.size();
        if (ArrayListIterate.canAccessInternalArray(list)) {
            ArrayIterate.sort(ArrayListIterate.getInternalArray(list), size, comparator);
        } else {
            Collections.sort(list, comparator);
        }
        return list;
    }

    public static <T> void toArray(ArrayList<T> list, T[] target, int startIndex, int sourceSize) {
        if (ArrayListIterate.canAccessInternalArray(list)) {
            System.arraycopy(ArrayListIterate.getInternalArray(list), 0, target, startIndex, sourceSize);
        } else {
            RandomAccessListIterate.toArray(list, target, startIndex, sourceSize);
        }
    }

    public static <T> ArrayList<T> take(ArrayList<T> list, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        return ArrayListIterate.take(list, count, new ArrayList(Math.min(list.size(), count)));
    }

    public static <T, R extends Collection<T>> R take(ArrayList<T> list, int count, R targetList) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            int end = Math.min(size, count);
            for (int i = 0; i < end; ++i) {
                targetList.add(elements[i]);
            }
            return targetList;
        }
        return RandomAccessListIterate.take(list, count, targetList);
    }

    public static <T> ArrayList<T> drop(ArrayList<T> list, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        return ArrayListIterate.drop(list, count, new ArrayList(list.size() - Math.min(list.size(), count)));
    }

    public static <T, R extends Collection<T>> R drop(ArrayList<T> list, int count, R targetList) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        int size = list.size();
        if (count >= size) {
            return targetList;
        }
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = count; i < size; ++i) {
                targetList.add(elements[i]);
            }
            return targetList;
        }
        return RandomAccessListIterate.drop(list, count, targetList);
    }

    public static <T, V> FastListMultimap<V, T> groupBy(ArrayList<T> list, Function<? super T, ? extends V> function) {
        return ArrayListIterate.groupBy(list, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(ArrayList<T> list, Function<? super T, ? extends V> function, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                target.put(function.valueOf(elements[i]), elements[i]);
            }
            return target;
        }
        return RandomAccessListIterate.groupBy(list, function, target);
    }

    public static <T, V> FastListMultimap<V, T> groupByEach(ArrayList<T> list, Function<? super T, ? extends Iterable<V>> function) {
        return ArrayListIterate.groupByEach(list, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(ArrayList<T> list, Function<? super T, ? extends Iterable<V>> function, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                Iterable iterable = (Iterable)function.valueOf(elements[i]);
                for (Object key : iterable) {
                    target.put(key, elements[i]);
                }
            }
            return target;
        }
        return RandomAccessListIterate.groupByEach(list, function, target);
    }

    public static <T, V> MutableMap<V, T> groupByUniqueKey(ArrayList<T> list, Function<? super T, ? extends V> function) {
        return ArrayListIterate.groupByUniqueKey(list, function, UnifiedMap.newMap());
    }

    public static <T, V, R extends MutableMap<V, T>> R groupByUniqueKey(ArrayList<T> list, Function<? super T, ? extends V> function, R target) {
        if (list == null) {
            throw new IllegalArgumentException("Cannot perform a groupByUniqueKey on null");
        }
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                Object key = function.valueOf(elements[i]);
                if (target.put(key, elements[i]) == null) continue;
                throw new IllegalStateException("Key " + key + " already exists in map!");
            }
            return target;
        }
        return RandomAccessListIterate.groupByUniqueKey(list, function, target);
    }

    public static <X, Y> MutableList<Pair<X, Y>> zip(ArrayList<X> xs, Iterable<Y> ys) {
        return ArrayListIterate.zip(xs, ys, FastList.newList());
    }

    public static <X, Y, R extends Collection<Pair<X, Y>>> R zip(ArrayList<X> xs, Iterable<Y> ys, R targetCollection) {
        int size = xs.size();
        if (ArrayListIterate.isOptimizableArrayList(xs, size)) {
            Iterator<Y> yIterator = ys.iterator();
            X[] elements = ArrayListIterate.getInternalArray(xs);
            for (int i = 0; i < size && yIterator.hasNext(); ++i) {
                targetCollection.add(Tuples.pair(elements[i], yIterator.next()));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.zip(xs, ys, targetCollection);
    }

    public static <T> MutableList<Pair<T, Integer>> zipWithIndex(ArrayList<T> list) {
        return ArrayListIterate.zipWithIndex(list, FastList.newList());
    }

    public static <T, R extends Collection<Pair<T, Integer>>> R zipWithIndex(ArrayList<T> list, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                targetCollection.add(Tuples.pair(elements[i], i));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.zipWithIndex(list, targetCollection);
    }

    public static <T> MutableList<T> takeWhile(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            FastList result = FastList.newList();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T element = elements[i];
                if (!predicate.accept(element)) {
                    return result;
                }
                result.add(element);
            }
            return result;
        }
        return RandomAccessListIterate.takeWhile(list, predicate);
    }

    public static <T> MutableList<T> dropWhile(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            FastList result = FastList.newList();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T element = elements[i];
                if (predicate.accept(element)) continue;
                result.add(element);
                for (int j = i + 1; j < size; ++j) {
                    T eachNotDropped = elements[j];
                    result.add(eachNotDropped);
                }
                return result;
            }
            return result;
        }
        return RandomAccessListIterate.dropWhile(list, predicate);
    }

    public static <T> PartitionMutableList<T> partitionWhile(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            PartitionFastList result = new PartitionFastList();
            MutableList selected = result.getSelected();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T each = elements[i];
                if (!predicate.accept(each)) {
                    MutableList rejected = result.getRejected();
                    rejected.add(each);
                    for (int j = i + 1; j < size; ++j) {
                        rejected.add(elements[j]);
                    }
                    return result;
                }
                selected.add(each);
            }
            return result;
        }
        return RandomAccessListIterate.partitionWhile(list, predicate);
    }

    private static boolean canAccessInternalArray(ArrayList<?> list) {
        return ELEMENT_DATA_FIELD != null && list.getClass() == ArrayList.class;
    }

    private static boolean isOptimizableArrayList(ArrayList<?> list, int newSize) {
        return newSize > 100 && ELEMENT_DATA_FIELD != null && list.getClass() == ArrayList.class;
    }

    private static <T> T[] getInternalArray(ArrayList<T> list) {
        try {
            return (Object[])ELEMENT_DATA_FIELD.get(list);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(ArrayList<T> list, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        ArrayListIterate.forEach(list, new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(ArrayList<T> list, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        ArrayListIterate.forEach(list, new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    static {
        Field data = null;
        Field size = null;
        try {
            data = ArrayList.class.getDeclaredField("elementData");
            size = ArrayList.class.getDeclaredField("size");
            try {
                data.setAccessible(true);
                size.setAccessible(true);
            }
            catch (SecurityException ignored) {
                data = null;
                size = null;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        ELEMENT_DATA_FIELD = data;
        SIZE_FIELD = size;
    }
}

