/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.internal.primitive;

import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharIteratorIterate {
    private CharIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(CharIterator iterator, CharProcedure procedure) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public static <R extends MutableCharCollection> R select(CharIterator iterator, CharPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            char item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableCharCollection> R reject(CharIterator iterator, CharPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            char item = iterator.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(CharIterator iterator, CharToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            char item = iterator.next();
            targetCollection.add((Object)function.valueOf(item));
        }
        return targetCollection;
    }

    public static char detectIfNone(CharIterator iterator, CharPredicate predicate, char ifNone) {
        while (iterator.hasNext()) {
            char item = iterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(CharIterator iterator, CharPredicate predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(CharIterator iterator, CharPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(CharIterator iterator, CharPredicate predicate) {
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(CharIterator iterator, CharPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(CharIterator iterator, T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public static long sum(CharIterator iterator) {
        long sum = 0L;
        while (iterator.hasNext()) {
            sum += (long)iterator.next();
        }
        return sum;
    }

    public static char max(CharIterator iterator) {
        char max = iterator.next();
        while (iterator.hasNext()) {
            char next = iterator.next();
            if (max >= next) continue;
            max = next;
        }
        return max;
    }

    public static char min(CharIterator iterator) {
        char min = iterator.next();
        while (iterator.hasNext()) {
            char next = iterator.next();
            if (next >= min) continue;
            min = next;
        }
        return min;
    }
}

