/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.ImmutableCharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableCharCollection;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseCharIterable;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveList.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableCharList
        extends AbstractUnmodifiableCharCollection
        implements MutableCharList
{
    private static final long serialVersionUID = 1L;

    UnmodifiableCharList(MutableCharList list)
    {
        super(list);
    }

    private MutableCharList getMutableCharList()
    {
        return (MutableCharList) this.getCharCollection();
    }

    public char get(int index)
    {
        return this.getMutableCharList().get(index);
    }

    public char getFirst()
    {
        return this.getMutableCharList().getFirst();
    }

    public char getLast()
    {
        return this.getMutableCharList().getLast();
    }

    public int indexOf(char value)
    {
        return this.getMutableCharList().indexOf(value);
    }

    public int lastIndexOf(char value)
    {
        return this.getMutableCharList().lastIndexOf(value);
    }

    public void addAtIndex(int index, char element)
    {
        throw new UnsupportedOperationException("Cannot call addAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, char... source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, CharIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public char removeAtIndex(int index)
    {
        throw new UnsupportedOperationException("Cannot call removeAtIndex() on " + this.getClass().getSimpleName());
    }

    public char set(int index, char element)
    {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableCharList with(char element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableCharList without(char element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableCharList withAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableCharList withoutAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharList select(CharPredicate predicate)
    {
        return this.getMutableCharList().select(predicate);
    }

    @Override
    public MutableCharList reject(CharPredicate predicate)
    {
        return this.getMutableCharList().reject(predicate);
    }

    @Override
    public <V> MutableList<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.getMutableCharList().collect(function);
    }

    public MutableCharList sortThis()
    {
        throw new UnsupportedOperationException("Cannot call sortThis() on " + this.getClass().getSimpleName());
    }

    public long dotProduct(CharList list)
    {
        return this.getMutableCharList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        return this.getMutableCharList().equals(otherList);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableCharList().hashCode();
    }

    @Override
    public MutableCharList asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableCharList asSynchronized()
    {
        return new SynchronizedCharList(this);
    }

    @Override
    public ImmutableCharList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return CharLists.immutable.with();
        }
        if (size == 1)
        {
            return CharLists.immutable.with(this.getFirst());
        }
        return CharLists.immutable.with(this.toArray());
    }

    public MutableCharList reverseThis()
    {
        throw new UnsupportedOperationException("Cannot call reverseThis() on " + this.getClass().getSimpleName());
    }

    public MutableCharList toReversed()
    {
        return this.getMutableCharList().toReversed();
    }

    public void forEachWithIndex(CharIntProcedure procedure)
    {
        this.getMutableCharList().forEachWithIndex(procedure);
    }

    public LazyCharIterable asReversed()
    {
        return ReverseCharIterable.adapt(this);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableCharList().injectIntoWithIndex(injectedValue, function);
    }

    /**
     * @since 6.0.
     */
    public MutableCharList distinct()
    {
        return this.getMutableCharList().distinct();
    }

    public MutableCharList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
