/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableByteShortMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteShortMap;
import com.gs.collections.api.map.primitive.ByteShortMap;

/**
 * ImmutableByteShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteShortMapFactoryImpl implements ImmutableByteShortMapFactory
{
    public ImmutableByteShortMap empty()
    {
        return ImmutableByteShortEmptyMap.INSTANCE;
    }

    public ImmutableByteShortMap of()
    {
        return this.empty();
    }

    public ImmutableByteShortMap with()
    {
        return this.empty();
    }

    public ImmutableByteShortMap of(byte key, short value)
    {
        return this.with(key, value);
    }

    public ImmutableByteShortMap with(byte key, short value)
    {
        return new ImmutableByteShortSingletonMap(key, value);
    }

    public ImmutableByteShortMap ofAll(ByteShortMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteShortMap withAll(ByteShortMap map)
    {
        if (map instanceof ImmutableByteShortMap)
        {
            return (ImmutableByteShortMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteShortSingletonMap(key, map.get(key));
        }
        return new ImmutableByteShortHashMap(map);
    }
}
