/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Set;

import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectCharPredicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectCharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.ImmutableObjectCharMap;
import com.gs.collections.api.map.primitive.ObjectCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.ObjectCharPair;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.iterator.ImmutableEmptyCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.utility.LazyIterate;

/**
 * ImmutableObjectCharEmptyMap is an optimization for {@link ImmutableObjectCharMap} of size 0.
 * This file was automatically generated from template file immutableObjectPrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectCharEmptyMap<K> implements ImmutableObjectCharMap<K>, Serializable
{
    static final ImmutableObjectCharMap<?> INSTANCE = new ImmutableObjectCharEmptyMap<Object>();

    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\0';

    private Object readResolve()
    {
        return INSTANCE;
    }

    public CharIterator charIterator()
    {
        return ImmutableEmptyCharIterator.INSTANCE;
    }

    public void forEach(CharProcedure procedure)
    {
    }

    public int count(CharPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public ImmutableCharCollection select(CharPredicate predicate)
    {
        return CharLists.immutable.with();
    }

    public ImmutableCharCollection reject(CharPredicate predicate)
    {
        return CharLists.immutable.with();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public long sum()
    {
        return 0L;
    }

    public char min()
    {
        throw new NoSuchElementException();
    }

    public char max()
    {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public char minIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public char[] toSortedArray()
    {
        return new char[0];
    }

    public MutableCharList toSortedList()
    {
        return new CharArrayList();
    }

    public char[] toArray()
    {
        return new char[0];
    }

    public boolean contains(char value)
    {
        return false;
    }

    public boolean containsAll(char... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(CharIterable source)
    {
        return source.isEmpty();
    }

    public MutableCharList toList()
    {
        return new CharArrayList();
    }

    public MutableCharSet toSet()
    {
        return new CharHashSet();
    }

    public MutableCharBag toBag()
    {
        return new CharHashBag();
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public ImmutableObjectCharMap<K> newWithKeyValue(K key, char value)
    {
        return new ImmutableObjectCharSingletonMap<K>(key, value);
    }

    public ImmutableObjectCharMap<K> newWithoutKey(K key)
    {
        return this;
    }

    public ImmutableObjectCharMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        return this;
    }

    public char get(Object key)
    {
        return EMPTY_VALUE;
    }

    public char getOrThrow(Object key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public char getIfAbsent(Object key, char ifAbsent)
    {
        return ifAbsent;
    }

    public boolean containsKey(Object key)
    {
        return false;
    }

    public boolean containsValue(char value)
    {
        return false;
    }

    public void forEachValue(CharProcedure procedure)
    {
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
    }

    public void forEachKeyValue(ObjectCharProcedure<? super K> objectCharProcedure)
    {
    }

    public ImmutableObjectCharMap<K> select(ObjectCharPredicate<? super K> objectCharPredicate)
    {
        return this;
    }

    public ImmutableObjectCharMap<K> reject(ObjectCharPredicate<? super K> objectCharPredicate)
    {
        return this;
    }

    public ImmutableObjectCharMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public Set<K> keySet()
    {
        return Sets.immutable.<K>of().castToSet();
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(new CharArrayList());
    }

    public LazyIterable<K> keysView()
    {
        return LazyIterate.empty();
    }

    public RichIterable<ObjectCharPair<K>> keyValuesView()
    {
        return LazyIterate.empty();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ObjectCharMap))
        {
            return false;
        }
        ObjectCharMap<K> map = (ObjectCharMap<K>) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
