/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ShortShortMap;
import com.gs.collections.api.map.primitive.ImmutableShortShortMap;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.ShortShortPair;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.iterator.ImmutableEmptyShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyShortIterate;

/**
 * ImmutableShortShortEmptyMap is an optimization for {@link ImmutableShortShortMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableShortShortEmptyMap implements ImmutableShortShortMap, Serializable
{
    static final ImmutableShortShortMap INSTANCE = new ImmutableShortShortEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final short EMPTY_VALUE = (short) 0;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public short get(short key)
    {
        return EMPTY_VALUE;
    }

    public short getIfAbsent(short key, short ifAbsent)
    {
        return ifAbsent;
    }

    public short getOrThrow(short key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key)
    {
        return false;
    }

    public boolean containsValue(short value)
    {
        return false;
    }

    public void forEachValue(ShortProcedure procedure)
    {
    }

    public void forEachKey(ShortProcedure procedure)
    {
    }

    public void forEachKeyValue(ShortShortProcedure procedure)
    {
    }

    public LazyShortIterable keysView()
    {
        return LazyShortIterate.empty();
    }

    public RichIterable<ShortShortPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableShortShortMap select(ShortShortPredicate predicate)
    {
        return this;
    }

    public ImmutableShortShortMap reject(ShortShortPredicate predicate)
    {
        return this;
    }

    public ImmutableShortShortMap toImmutable()
    {
        return this;
    }

    public ShortIterator shortIterator()
    {
        return ImmutableEmptyShortIterator.INSTANCE;
    }

    public void forEach(ShortProcedure procedure)
    {
    }

    public int count(ShortPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public short min()
    {
        throw new NoSuchElementException();
    }

    public short max()
    {
        throw new NoSuchElementException();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public short minIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public short[] toSortedArray()
    {
        return new short[0];
    }

    public MutableShortList toSortedList()
    {
        return new ShortArrayList();
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public ImmutableShortCollection select(ShortPredicate predicate)
    {
        return ShortLists.immutable.with();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate)
    {
        return ShortLists.immutable.with();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public short[] toArray()
    {
        return new short[0];
    }

    public boolean contains(short value)
    {
        return false;
    }

    public boolean containsAll(short... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ShortIterable source)
    {
        return source.isEmpty();
    }

    public MutableShortList toList()
    {
        return new ShortArrayList();
    }

    public MutableShortSet toSet()
    {
        return new ShortHashSet();
    }

    public MutableShortBag toBag()
    {
        return new ShortHashBag();
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public ImmutableShortShortMap newWithKeyValue(short key, short value)
    {
        return new ImmutableShortShortSingletonMap(key, value);
    }

    public ImmutableShortShortMap newWithoutKey(short key)
    {
        return this;
    }

    public ImmutableShortShortMap newWithoutAllKeys(ShortIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableShortSet keySet()
    {
        return UnmodifiableShortSet.of(new ShortHashSet());
    }

    public MutableShortCollection values()
    {
        return UnmodifiableShortCollection.of(new ShortArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ShortShortMap))
        {
            return false;
        }
        ShortShortMap map = (ShortShortMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
