/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.iterator.ImmutableEmptyIntIterator;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableIntSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableIntEmptySet
implements ImmutableIntSet,
Serializable {
    static final ImmutableIntSet INSTANCE = new ImmutableIntEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableIntEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableIntSet newWith(int element) {
        return new ImmutableIntSingletonSet(element);
    }

    public ImmutableIntSet newWithout(int element) {
        return this;
    }

    public ImmutableIntSet newWithAll(IntIterable elements) {
        return IntSets.immutable.withAll(elements);
    }

    public ImmutableIntSet newWithoutAll(IntIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(int value) {
        return false;
    }

    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(int ... elements) {
        return elements.length == 0;
    }

    public void forEach(IntProcedure procedure) {
    }

    public ImmutableIntSet select(IntPredicate predicate) {
        return this;
    }

    public ImmutableIntSet reject(IntPredicate predicate) {
        return this;
    }

    public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    public MutableIntList toList() {
        return new IntArrayList();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    public int count(IntPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    public long sum() {
        return 0L;
    }

    public int min() {
        throw new NoSuchElementException();
    }

    public int max() {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public int[] toSortedArray() {
        return new int[0];
    }

    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet set = (IntSet)obj;
        return set.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    public IntSet freeze() {
        return this;
    }

    public ImmutableIntSet toImmutable() {
        return this;
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public int[] toArray() {
        return new int[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return ImmutableEmptyIntIterator.INSTANCE;
    }
}

