/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableIntSingletonSet
implements ImmutableIntSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int element;

    ImmutableIntSingletonSet(int element) {
        this.element = element;
    }

    public ImmutableIntSet newWith(int element) {
        return IntSets.immutable.with(new int[]{this.element, element});
    }

    public ImmutableIntSet newWithout(int element) {
        return this.element == element ? IntSets.immutable.with() : this;
    }

    public ImmutableIntSet newWithAll(IntIterable elements) {
        return IntHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableIntSet newWithoutAll(IntIterable elements) {
        return elements.contains(this.element) ? IntSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(int value) {
        return this.element == value;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.element == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.element == value) continue;
            return false;
        }
        return true;
    }

    public void forEach(IntProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableIntSet select(IntPredicate predicate) {
        return predicate.accept(this.element) ? IntHashSet.newSetWith(this.element).toImmutable() : new IntHashSet().toImmutable();
    }

    public ImmutableIntSet reject(IntPredicate predicate) {
        return predicate.accept(this.element) ? new IntHashSet().toImmutable() : IntHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableIntList toList() {
        return IntArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(int item) {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(IntIntProcedure intIntProcedure) {
        intIntProcedure.value(this.element, 1);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(IntPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.element);
    }

    public long sum() {
        return this.element;
    }

    public int min() {
        return this.element;
    }

    public int max() {
        return this.element;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.element;
    }

    public int minIfEmpty(int defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public int[] toSortedArray() {
        return new int[]{this.element};
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet set = (IntSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return this.element;
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.element);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.element);
    }

    public IntSet freeze() {
        return this;
    }

    public ImmutableIntSet toImmutable() {
        return this;
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public int[] toArray() {
        return new int[]{this.element};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)IntHashSet.newSetWith(this.element).intIterator());
    }
}

